package zio.aws.timestreamquery.model
import java.lang.Integer
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.{
  NextTagsForResourceResultsToken,
  MaxTagsForResourceResult,
  AmazonResourceName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    resourceARN: AmazonResourceName,
    maxResults: Option[MaxTagsForResourceResult] = None,
    nextToken: Option[NextTagsForResourceResultsToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxTagsForResourceResult.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          NextTagsForResourceResultsToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.timestreamquery.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.ListTagsForResourceRequest =
      zio.aws.timestreamquery.model.ListTagsForResourceRequest(
        resourceARN,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def resourceARN: AmazonResourceName
    def maxResults: Option[MaxTagsForResourceResult]
    def nextToken: Option[NextTagsForResourceResultsToken]
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getMaxResults: ZIO[Any, AwsError, MaxTagsForResourceResult] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextTagsForResourceResultsToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceRequest
  ) extends zio.aws.timestreamquery.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.timestreamquery.model.primitives
        .AmazonResourceName(impl.resourceARN())
    override val maxResults: Option[MaxTagsForResourceResult] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.MaxTagsForResourceResult(value)
      )
    override val nextToken: Option[NextTagsForResourceResultsToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.timestreamquery.model.primitives
          .NextTagsForResourceResultsToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceRequest
  ): zio.aws.timestreamquery.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
