package zio.aws.timestreamquery
import zio.aws.timestreamquery.model.DescribeScheduledQueryResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.timestreamquery.model.primitives.QueryId
import software.amazon.awssdk.services.timestreamquery.model.{
  ListScheduledQueriesRequest,
  QueryResponse,
  DescribeEndpointsRequest,
  UpdateScheduledQueryRequest,
  CreateScheduledQueryRequest,
  ListTagsForResourceRequest,
  Tag,
  CreateScheduledQueryResponse,
  ExecuteScheduledQueryResponse,
  DescribeScheduledQueryRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DescribeEndpointsResponse,
  DeleteScheduledQueryResponse,
  CancelQueryResponse,
  QueryRequest,
  DeleteScheduledQueryRequest,
  UntagResourceRequest,
  ListScheduledQueriesResponse,
  PrepareQueryResponse,
  ExecuteScheduledQueryRequest,
  CancelQueryRequest,
  ScheduledQuery,
  DescribeScheduledQueryResponse,
  TagResourceResponse,
  UpdateScheduledQueryResponse,
  TagResourceRequest,
  PrepareQueryRequest
}
import software.amazon.awssdk.services.timestreamquery.{
  TimestreamQueryAsyncClientBuilder,
  TimestreamQueryAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait TimestreamQuery extends AspectSupport[TimestreamQuery] {
  val api: TimestreamQueryAsyncClient
  def deleteScheduledQuery(
      request: zio.aws.timestreamquery.model.DeleteScheduledQueryRequest
  ): IO[AwsError, Unit]
  def createScheduledQuery(
      request: zio.aws.timestreamquery.model.CreateScheduledQueryRequest
  ): IO[
    AwsError,
    zio.aws.timestreamquery.model.CreateScheduledQueryResponse.ReadOnly
  ]
  def updateScheduledQuery(
      request: zio.aws.timestreamquery.model.UpdateScheduledQueryRequest
  ): IO[AwsError, Unit]
  def prepareQuery(
      request: zio.aws.timestreamquery.model.PrepareQueryRequest
  ): IO[AwsError, zio.aws.timestreamquery.model.PrepareQueryResponse.ReadOnly]
  def query(
      request: zio.aws.timestreamquery.model.QueryRequest
  ): IO[AwsError, StreamingOutputResult[
    Any,
    zio.aws.timestreamquery.model.QueryResponse.ReadOnly,
    QueryId
  ]]
  def queryPaginated(
      request: zio.aws.timestreamquery.model.QueryRequest
  ): IO[AwsError, zio.aws.timestreamquery.model.QueryResponse.ReadOnly]
  def untagResource(
      request: zio.aws.timestreamquery.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.timestreamquery.model.UntagResourceResponse.ReadOnly]
  def executeScheduledQuery(
      request: zio.aws.timestreamquery.model.ExecuteScheduledQueryRequest
  ): IO[AwsError, Unit]
  def listScheduledQueries(
      request: zio.aws.timestreamquery.model.ListScheduledQueriesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.timestreamquery.model.ScheduledQuery.ReadOnly
  ]
  def listScheduledQueriesPaginated(
      request: zio.aws.timestreamquery.model.ListScheduledQueriesRequest
  ): IO[
    AwsError,
    zio.aws.timestreamquery.model.ListScheduledQueriesResponse.ReadOnly
  ]
  def describeEndpoints(
      request: zio.aws.timestreamquery.model.DescribeEndpointsRequest
  ): IO[
    AwsError,
    zio.aws.timestreamquery.model.DescribeEndpointsResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.timestreamquery.model.ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.timestreamquery.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(
      request: zio.aws.timestreamquery.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.timestreamquery.model.ListTagsForResourceResponse.ReadOnly
  ]
  def cancelQuery(
      request: zio.aws.timestreamquery.model.CancelQueryRequest
  ): IO[AwsError, zio.aws.timestreamquery.model.CancelQueryResponse.ReadOnly]
  def tagResource(
      request: zio.aws.timestreamquery.model.TagResourceRequest
  ): IO[AwsError, zio.aws.timestreamquery.model.TagResourceResponse.ReadOnly]
  def describeScheduledQuery(
      request: zio.aws.timestreamquery.model.DescribeScheduledQueryRequest
  ): IO[AwsError, ReadOnly]
}
object TimestreamQuery {
  val live: ZLayer[AwsConfig, java.lang.Throwable, TimestreamQuery] =
    customized(identity)
  def customized(
      customization: TimestreamQueryAsyncClientBuilder => TimestreamQueryAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, TimestreamQuery] = managed(
    customization
  ).toLayer
  def managed(
      customization: TimestreamQueryAsyncClientBuilder => TimestreamQueryAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, TimestreamQuery] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = TimestreamQueryAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[TimestreamQueryAsyncClient, TimestreamQueryAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        TimestreamQueryAsyncClient,
        TimestreamQueryAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new TimestreamQueryImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class TimestreamQueryImpl[R](
      override val api: TimestreamQueryAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends TimestreamQuery
      with AwsServiceBase[R] {
    override val serviceName: String = "TimestreamQuery"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): TimestreamQueryImpl[R1] = new TimestreamQueryImpl(api, newAspect, r)
    def deleteScheduledQuery(
        request: zio.aws.timestreamquery.model.DeleteScheduledQueryRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteScheduledQueryRequest,
      DeleteScheduledQueryResponse
    ]("deleteScheduledQuery", api.deleteScheduledQuery)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createScheduledQuery(
        request: zio.aws.timestreamquery.model.CreateScheduledQueryRequest
    ): IO[
      AwsError,
      zio.aws.timestreamquery.model.CreateScheduledQueryResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateScheduledQueryRequest,
      CreateScheduledQueryResponse
    ]("createScheduledQuery", api.createScheduledQuery)(request.buildAwsValue())
      .map(zio.aws.timestreamquery.model.CreateScheduledQueryResponse.wrap)
      .provideEnvironment(r)
    def updateScheduledQuery(
        request: zio.aws.timestreamquery.model.UpdateScheduledQueryRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateScheduledQueryRequest,
      UpdateScheduledQueryResponse
    ]("updateScheduledQuery", api.updateScheduledQuery)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def prepareQuery(
        request: zio.aws.timestreamquery.model.PrepareQueryRequest
    ): IO[
      AwsError,
      zio.aws.timestreamquery.model.PrepareQueryResponse.ReadOnly
    ] = asyncRequestResponse[PrepareQueryRequest, PrepareQueryResponse](
      "prepareQuery",
      api.prepareQuery
    )(request.buildAwsValue())
      .map(zio.aws.timestreamquery.model.PrepareQueryResponse.wrap)
      .provideEnvironment(r)
    def query(
        request: zio.aws.timestreamquery.model.QueryRequest
    ): IO[AwsError, StreamingOutputResult[
      Any,
      zio.aws.timestreamquery.model.QueryResponse.ReadOnly,
      QueryId
    ]] = asyncPaginatedRequest[QueryRequest, QueryResponse, java.lang.String](
      "query",
      api.query,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk(r.queryId())
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.timestreamquery.model.QueryResponse.wrap)
          .mapOutput(
            _.map(item =>
              zio.aws.timestreamquery.model.primitives.QueryId(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def queryPaginated(
        request: zio.aws.timestreamquery.model.QueryRequest
    ): IO[AwsError, zio.aws.timestreamquery.model.QueryResponse.ReadOnly] =
      asyncRequestResponse[QueryRequest, QueryResponse]("query", api.query)(
        request.buildAwsValue()
      ).map(zio.aws.timestreamquery.model.QueryResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.timestreamquery.model.UntagResourceRequest
    ): IO[
      AwsError,
      zio.aws.timestreamquery.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(zio.aws.timestreamquery.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def executeScheduledQuery(
        request: zio.aws.timestreamquery.model.ExecuteScheduledQueryRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ExecuteScheduledQueryRequest,
      ExecuteScheduledQueryResponse
    ]("executeScheduledQuery", api.executeScheduledQuery)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listScheduledQueries(
        request: zio.aws.timestreamquery.model.ListScheduledQueriesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.ScheduledQuery.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListScheduledQueriesRequest,
      ListScheduledQueriesResponse,
      ScheduledQuery
    ](
      "listScheduledQueries",
      api.listScheduledQueries,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.scheduledQueries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.timestreamquery.model.ScheduledQuery.wrap(item))
      .provideEnvironment(r)
    def listScheduledQueriesPaginated(
        request: zio.aws.timestreamquery.model.ListScheduledQueriesRequest
    ): IO[
      AwsError,
      zio.aws.timestreamquery.model.ListScheduledQueriesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListScheduledQueriesRequest,
      ListScheduledQueriesResponse
    ]("listScheduledQueries", api.listScheduledQueries)(request.buildAwsValue())
      .map(zio.aws.timestreamquery.model.ListScheduledQueriesResponse.wrap)
      .provideEnvironment(r)
    def describeEndpoints(
        request: zio.aws.timestreamquery.model.DescribeEndpointsRequest
    ): IO[
      AwsError,
      zio.aws.timestreamquery.model.DescribeEndpointsResponse.ReadOnly
    ] =
      asyncRequestResponse[DescribeEndpointsRequest, DescribeEndpointsResponse](
        "describeEndpoints",
        api.describeEndpoints
      )(request.buildAwsValue())
        .map(zio.aws.timestreamquery.model.DescribeEndpointsResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.timestreamquery.model.ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.timestreamquery.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse,
        Tag
      ](
        "listTagsForResource",
        api.listTagsForResource,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.timestreamquery.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: zio.aws.timestreamquery.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.timestreamquery.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.timestreamquery.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def cancelQuery(
        request: zio.aws.timestreamquery.model.CancelQueryRequest
    ): IO[
      AwsError,
      zio.aws.timestreamquery.model.CancelQueryResponse.ReadOnly
    ] = asyncRequestResponse[CancelQueryRequest, CancelQueryResponse](
      "cancelQuery",
      api.cancelQuery
    )(request.buildAwsValue())
      .map(zio.aws.timestreamquery.model.CancelQueryResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.timestreamquery.model.TagResourceRequest
    ): IO[
      AwsError,
      zio.aws.timestreamquery.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[TagResourceRequest, TagResourceResponse](
      "tagResource",
      api.tagResource
    )(request.buildAwsValue())
      .map(zio.aws.timestreamquery.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def describeScheduledQuery(
        request: zio.aws.timestreamquery.model.DescribeScheduledQueryRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      DescribeScheduledQueryRequest,
      DescribeScheduledQueryResponse
    ]("describeScheduledQuery", api.describeScheduledQuery)(
      request.buildAwsValue()
    ).map(zio.aws.timestreamquery.model.DescribeScheduledQueryResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteScheduledQuery(
      request: zio.aws.timestreamquery.model.DeleteScheduledQueryRequest
  ): ZIO[zio.aws.timestreamquery.TimestreamQuery, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteScheduledQuery(request))
  def createScheduledQuery(
      request: zio.aws.timestreamquery.model.CreateScheduledQueryRequest
  ): ZIO[
    zio.aws.timestreamquery.TimestreamQuery,
    AwsError,
    zio.aws.timestreamquery.model.CreateScheduledQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createScheduledQuery(request))
  def updateScheduledQuery(
      request: zio.aws.timestreamquery.model.UpdateScheduledQueryRequest
  ): ZIO[zio.aws.timestreamquery.TimestreamQuery, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateScheduledQuery(request))
  def prepareQuery(
      request: zio.aws.timestreamquery.model.PrepareQueryRequest
  ): ZIO[
    zio.aws.timestreamquery.TimestreamQuery,
    AwsError,
    zio.aws.timestreamquery.model.PrepareQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.prepareQuery(request))
  def query(request: zio.aws.timestreamquery.model.QueryRequest): ZIO[
    zio.aws.timestreamquery.TimestreamQuery,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.timestreamquery.model.QueryResponse.ReadOnly,
      QueryId
    ]
  ] = ZIO.serviceWithZIO(_.query(request))
  def queryPaginated(request: zio.aws.timestreamquery.model.QueryRequest): ZIO[
    zio.aws.timestreamquery.TimestreamQuery,
    AwsError,
    zio.aws.timestreamquery.model.QueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.queryPaginated(request))
  def untagResource(
      request: zio.aws.timestreamquery.model.UntagResourceRequest
  ): ZIO[
    zio.aws.timestreamquery.TimestreamQuery,
    AwsError,
    zio.aws.timestreamquery.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def executeScheduledQuery(
      request: zio.aws.timestreamquery.model.ExecuteScheduledQueryRequest
  ): ZIO[zio.aws.timestreamquery.TimestreamQuery, AwsError, Unit] =
    ZIO.serviceWithZIO(_.executeScheduledQuery(request))
  def listScheduledQueries(
      request: zio.aws.timestreamquery.model.ListScheduledQueriesRequest
  ): ZStream[
    zio.aws.timestreamquery.TimestreamQuery,
    AwsError,
    zio.aws.timestreamquery.model.ScheduledQuery.ReadOnly
  ] = ZStream.serviceWithStream(_.listScheduledQueries(request))
  def listScheduledQueriesPaginated(
      request: zio.aws.timestreamquery.model.ListScheduledQueriesRequest
  ): ZIO[
    zio.aws.timestreamquery.TimestreamQuery,
    AwsError,
    zio.aws.timestreamquery.model.ListScheduledQueriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listScheduledQueriesPaginated(request))
  def describeEndpoints(
      request: zio.aws.timestreamquery.model.DescribeEndpointsRequest
  ): ZIO[
    zio.aws.timestreamquery.TimestreamQuery,
    AwsError,
    zio.aws.timestreamquery.model.DescribeEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpoints(request))
  def listTagsForResource(
      request: zio.aws.timestreamquery.model.ListTagsForResourceRequest
  ): ZStream[
    zio.aws.timestreamquery.TimestreamQuery,
    AwsError,
    zio.aws.timestreamquery.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(
      request: zio.aws.timestreamquery.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.timestreamquery.TimestreamQuery,
    AwsError,
    zio.aws.timestreamquery.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def cancelQuery(
      request: zio.aws.timestreamquery.model.CancelQueryRequest
  ): ZIO[
    zio.aws.timestreamquery.TimestreamQuery,
    AwsError,
    zio.aws.timestreamquery.model.CancelQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelQuery(request))
  def tagResource(
      request: zio.aws.timestreamquery.model.TagResourceRequest
  ): ZIO[
    zio.aws.timestreamquery.TimestreamQuery,
    AwsError,
    zio.aws.timestreamquery.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def describeScheduledQuery(
      request: zio.aws.timestreamquery.model.DescribeScheduledQueryRequest
  ): ZIO[zio.aws.timestreamquery.TimestreamQuery, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeScheduledQuery(request))
}
