package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Row(data: Iterable[zio.aws.timestreamquery.model.Datum]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.Row = {
    import Row.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.Row
      .builder()
      .data(data.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.Row.ReadOnly =
    zio.aws.timestreamquery.model.Row.wrap(buildAwsValue())
}
object Row {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.Row
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.Row =
      zio.aws.timestreamquery.model.Row(data.map { item =>
        item.asEditable
      })
    def data: List[zio.aws.timestreamquery.model.Datum.ReadOnly]
    def getData: ZIO[Any, Nothing, List[
      zio.aws.timestreamquery.model.Datum.ReadOnly
    ]] = ZIO.succeed(data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.Row
  ) extends zio.aws.timestreamquery.model.Row.ReadOnly {
    override val data: List[zio.aws.timestreamquery.model.Datum.ReadOnly] = impl
      .data()
      .asScala
      .map { item =>
        zio.aws.timestreamquery.model.Datum.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.Row
  ): zio.aws.timestreamquery.model.Row.ReadOnly = new Wrapper(impl)
}
