package zio.aws.timestreamquery.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.timestreamquery.model.primitives.{
  ClientToken,
  Time,
  AmazonResourceName
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ExecuteScheduledQueryRequest(
    scheduledQueryArn: AmazonResourceName,
    invocationTime: Time,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.ExecuteScheduledQueryRequest = {
    import ExecuteScheduledQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.ExecuteScheduledQueryRequest
      .builder()
      .scheduledQueryArn(
        AmazonResourceName.unwrap(scheduledQueryArn): java.lang.String
      )
      .invocationTime(Time.unwrap(invocationTime): Instant)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.ExecuteScheduledQueryRequest.ReadOnly =
    zio.aws.timestreamquery.model.ExecuteScheduledQueryRequest
      .wrap(buildAwsValue())
}
object ExecuteScheduledQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.ExecuteScheduledQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.ExecuteScheduledQueryRequest =
      zio.aws.timestreamquery.model.ExecuteScheduledQueryRequest(
        scheduledQueryArn,
        invocationTime,
        clientToken.map(value => value)
      )
    def scheduledQueryArn: AmazonResourceName
    def invocationTime: Time
    def clientToken: Optional[ClientToken]
    def getScheduledQueryArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(scheduledQueryArn)
    def getInvocationTime: ZIO[Any, Nothing, Time] = ZIO.succeed(invocationTime)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.ExecuteScheduledQueryRequest
  ) extends zio.aws.timestreamquery.model.ExecuteScheduledQueryRequest.ReadOnly {
    override val scheduledQueryArn: AmazonResourceName =
      zio.aws.timestreamquery.model.primitives
        .AmazonResourceName(impl.scheduledQueryArn())
    override val invocationTime: Time =
      zio.aws.timestreamquery.model.primitives.Time(impl.invocationTime())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.timestreamquery.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.ExecuteScheduledQueryRequest
  ): zio.aws.timestreamquery.model.ExecuteScheduledQueryRequest.ReadOnly =
    new Wrapper(impl)
}
