package zio.aws.timestreamquery.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.timestreamquery.model.primitives.{
  NextTagsForResourceResultsToken,
  MaxTagsForResourceResult,
  AmazonResourceName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(
    resourceARN: AmazonResourceName,
    maxResults: Optional[MaxTagsForResourceResult] = Optional.Absent,
    nextToken: Optional[NextTagsForResourceResultsToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxTagsForResourceResult.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          NextTagsForResourceResultsToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.timestreamquery.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.ListTagsForResourceRequest =
      zio.aws.timestreamquery.model.ListTagsForResourceRequest(
        resourceARN,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def resourceARN: AmazonResourceName
    def maxResults: Optional[MaxTagsForResourceResult]
    def nextToken: Optional[NextTagsForResourceResultsToken]
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getMaxResults: ZIO[Any, AwsError, MaxTagsForResourceResult] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextTagsForResourceResultsToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceRequest
  ) extends zio.aws.timestreamquery.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.timestreamquery.model.primitives
        .AmazonResourceName(impl.resourceARN())
    override val maxResults: Optional[MaxTagsForResourceResult] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.timestreamquery.model.primitives
            .MaxTagsForResourceResult(value)
        )
    override val nextToken: Optional[NextTagsForResourceResultsToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.timestreamquery.model.primitives
            .NextTagsForResourceResultsToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceRequest
  ): zio.aws.timestreamquery.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
