package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.AmazonResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateScheduledQueryRequest(
    scheduledQueryArn: AmazonResourceName,
    state: zio.aws.timestreamquery.model.ScheduledQueryState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.UpdateScheduledQueryRequest = {
    import UpdateScheduledQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.UpdateScheduledQueryRequest
      .builder()
      .scheduledQueryArn(
        AmazonResourceName.unwrap(scheduledQueryArn): java.lang.String
      )
      .state(state.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.UpdateScheduledQueryRequest.ReadOnly =
    zio.aws.timestreamquery.model.UpdateScheduledQueryRequest
      .wrap(buildAwsValue())
}
object UpdateScheduledQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.UpdateScheduledQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.UpdateScheduledQueryRequest =
      zio.aws.timestreamquery.model
        .UpdateScheduledQueryRequest(scheduledQueryArn, state)
    def scheduledQueryArn: AmazonResourceName
    def state: zio.aws.timestreamquery.model.ScheduledQueryState
    def getScheduledQueryArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(scheduledQueryArn)
    def getState
        : ZIO[Any, Nothing, zio.aws.timestreamquery.model.ScheduledQueryState] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.UpdateScheduledQueryRequest
  ) extends zio.aws.timestreamquery.model.UpdateScheduledQueryRequest.ReadOnly {
    override val scheduledQueryArn: AmazonResourceName =
      zio.aws.timestreamquery.model.primitives
        .AmazonResourceName(impl.scheduledQueryArn())
    override val state: zio.aws.timestreamquery.model.ScheduledQueryState =
      zio.aws.timestreamquery.model.ScheduledQueryState.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.UpdateScheduledQueryRequest
  ): zio.aws.timestreamquery.model.UpdateScheduledQueryRequest.ReadOnly =
    new Wrapper(impl)
}
