package zio.aws.timestreamquery.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.timestreamquery.model.primitives.{ErrorMessage, Time}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ScheduledQueryRunSummary(
    invocationTime: Optional[Time] = Optional.Absent,
    triggerTime: Optional[Time] = Optional.Absent,
    runStatus: Optional[zio.aws.timestreamquery.model.ScheduledQueryRunStatus] =
      Optional.Absent,
    executionStats: Optional[zio.aws.timestreamquery.model.ExecutionStats] =
      Optional.Absent,
    errorReportLocation: Optional[
      zio.aws.timestreamquery.model.ErrorReportLocation
    ] = Optional.Absent,
    failureReason: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummary = {
    import ScheduledQueryRunSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummary
      .builder()
      .optionallyWith(invocationTime.map(value => Time.unwrap(value): Instant))(
        _.invocationTime
      )
      .optionallyWith(triggerTime.map(value => Time.unwrap(value): Instant))(
        _.triggerTime
      )
      .optionallyWith(runStatus.map(value => value.unwrap))(_.runStatus)
      .optionallyWith(executionStats.map(value => value.buildAwsValue()))(
        _.executionStats
      )
      .optionallyWith(errorReportLocation.map(value => value.buildAwsValue()))(
        _.errorReportLocation
      )
      .optionallyWith(
        failureReason.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.failureReason)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.ScheduledQueryRunSummary.ReadOnly =
    zio.aws.timestreamquery.model.ScheduledQueryRunSummary.wrap(buildAwsValue())
}
object ScheduledQueryRunSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.ScheduledQueryRunSummary =
      zio.aws.timestreamquery.model.ScheduledQueryRunSummary(
        invocationTime.map(value => value),
        triggerTime.map(value => value),
        runStatus.map(value => value),
        executionStats.map(value => value.asEditable),
        errorReportLocation.map(value => value.asEditable),
        failureReason.map(value => value)
      )
    def invocationTime: Optional[Time]
    def triggerTime: Optional[Time]
    def runStatus
        : Optional[zio.aws.timestreamquery.model.ScheduledQueryRunStatus]
    def executionStats
        : Optional[zio.aws.timestreamquery.model.ExecutionStats.ReadOnly]
    def errorReportLocation
        : Optional[zio.aws.timestreamquery.model.ErrorReportLocation.ReadOnly]
    def failureReason: Optional[ErrorMessage]
    def getInvocationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("invocationTime", invocationTime)
    def getTriggerTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("triggerTime", triggerTime)
    def getRunStatus: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.ScheduledQueryRunStatus
    ] = AwsError.unwrapOptionField("runStatus", runStatus)
    def getExecutionStats: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.ExecutionStats.ReadOnly
    ] = AwsError.unwrapOptionField("executionStats", executionStats)
    def getErrorReportLocation: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.ErrorReportLocation.ReadOnly
    ] = AwsError.unwrapOptionField("errorReportLocation", errorReportLocation)
    def getFailureReason: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummary
  ) extends zio.aws.timestreamquery.model.ScheduledQueryRunSummary.ReadOnly {
    override val invocationTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.invocationTime())
      .map(value => zio.aws.timestreamquery.model.primitives.Time(value))
    override val triggerTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.triggerTime())
      .map(value => zio.aws.timestreamquery.model.primitives.Time(value))
    override val runStatus
        : Optional[zio.aws.timestreamquery.model.ScheduledQueryRunStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runStatus())
        .map(value =>
          zio.aws.timestreamquery.model.ScheduledQueryRunStatus.wrap(value)
        )
    override val executionStats
        : Optional[zio.aws.timestreamquery.model.ExecutionStats.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionStats())
        .map(value => zio.aws.timestreamquery.model.ExecutionStats.wrap(value))
    override val errorReportLocation
        : Optional[zio.aws.timestreamquery.model.ErrorReportLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorReportLocation())
        .map(value =>
          zio.aws.timestreamquery.model.ErrorReportLocation.wrap(value)
        )
    override val failureReason: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.ErrorMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.ScheduledQueryRunSummary
  ): zio.aws.timestreamquery.model.ScheduledQueryRunSummary.ReadOnly =
    new Wrapper(impl)
}
