package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.{PaginationToken, QueryId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class QueryResponse(
    queryId: QueryId,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    rows: Iterable[zio.aws.timestreamquery.model.Row],
    columnInfo: Iterable[zio.aws.timestreamquery.model.ColumnInfo],
    queryStatus: Optional[zio.aws.timestreamquery.model.QueryStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.QueryResponse = {
    import QueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.QueryResponse
      .builder()
      .queryId(QueryId.unwrap(queryId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .rows(rows.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .columnInfo(columnInfo.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(queryStatus.map(value => value.buildAwsValue()))(
        _.queryStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.QueryResponse.ReadOnly =
    zio.aws.timestreamquery.model.QueryResponse.wrap(buildAwsValue())
}
object QueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.QueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.QueryResponse =
      zio.aws.timestreamquery.model.QueryResponse(
        queryId,
        nextToken.map(value => value),
        rows.map { item =>
          item.asEditable
        },
        columnInfo.map { item =>
          item.asEditable
        },
        queryStatus.map(value => value.asEditable)
      )
    def queryId: QueryId
    def nextToken: Optional[PaginationToken]
    def rows: List[zio.aws.timestreamquery.model.Row.ReadOnly]
    def columnInfo: List[zio.aws.timestreamquery.model.ColumnInfo.ReadOnly]
    def queryStatus
        : Optional[zio.aws.timestreamquery.model.QueryStatus.ReadOnly]
    def getQueryId: ZIO[Any, Nothing, QueryId] = ZIO.succeed(queryId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRows
        : ZIO[Any, Nothing, List[zio.aws.timestreamquery.model.Row.ReadOnly]] =
      ZIO.succeed(rows)
    def getColumnInfo: ZIO[Any, Nothing, List[
      zio.aws.timestreamquery.model.ColumnInfo.ReadOnly
    ]] = ZIO.succeed(columnInfo)
    def getQueryStatus: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.QueryStatus.ReadOnly
    ] = AwsError.unwrapOptionField("queryStatus", queryStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.QueryResponse
  ) extends zio.aws.timestreamquery.model.QueryResponse.ReadOnly {
    override val queryId: QueryId =
      zio.aws.timestreamquery.model.primitives.QueryId(impl.queryId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.PaginationToken(value)
      )
    override val rows: List[zio.aws.timestreamquery.model.Row.ReadOnly] = impl
      .rows()
      .asScala
      .map { item =>
        zio.aws.timestreamquery.model.Row.wrap(item)
      }
      .toList
    override val columnInfo
        : List[zio.aws.timestreamquery.model.ColumnInfo.ReadOnly] = impl
      .columnInfo()
      .asScala
      .map { item =>
        zio.aws.timestreamquery.model.ColumnInfo.wrap(item)
      }
      .toList
    override val queryStatus
        : Optional[zio.aws.timestreamquery.model.QueryStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryStatus())
        .map(value => zio.aws.timestreamquery.model.QueryStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.QueryResponse
  ): zio.aws.timestreamquery.model.QueryResponse.ReadOnly = new Wrapper(impl)
}
