package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeEndpointsResponse(
    endpoints: Iterable[zio.aws.timestreamquery.model.Endpoint]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsResponse = {
    import DescribeEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsResponse
      .builder()
      .endpoints(endpoints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.DescribeEndpointsResponse.ReadOnly =
    zio.aws.timestreamquery.model.DescribeEndpointsResponse
      .wrap(buildAwsValue())
}
object DescribeEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.DescribeEndpointsResponse =
      zio.aws.timestreamquery.model.DescribeEndpointsResponse(endpoints.map {
        item =>
          item.asEditable
      })
    def endpoints: List[zio.aws.timestreamquery.model.Endpoint.ReadOnly]
    def getEndpoints: ZIO[Any, Nothing, List[
      zio.aws.timestreamquery.model.Endpoint.ReadOnly
    ]] = ZIO.succeed(endpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsResponse
  ) extends zio.aws.timestreamquery.model.DescribeEndpointsResponse.ReadOnly {
    override val endpoints
        : List[zio.aws.timestreamquery.model.Endpoint.ReadOnly] = impl
      .endpoints()
      .asScala
      .map { item =>
        zio.aws.timestreamquery.model.Endpoint.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsResponse
  ): zio.aws.timestreamquery.model.DescribeEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
