package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.{NullableBoolean, QueryString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PrepareQueryRequest(
    queryString: QueryString,
    validateOnly: Option[NullableBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.PrepareQueryRequest = {
    import PrepareQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.PrepareQueryRequest
      .builder()
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(
        validateOnly.map(value =>
          NullableBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.validateOnly)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.PrepareQueryRequest.ReadOnly =
    zio.aws.timestreamquery.model.PrepareQueryRequest.wrap(buildAwsValue())
}
object PrepareQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.PrepareQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.PrepareQueryRequest =
      zio.aws.timestreamquery.model
        .PrepareQueryRequest(queryString, validateOnly.map(value => value))
    def queryString: QueryString
    def validateOnly: Option[NullableBoolean]
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getValidateOnly: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("validateOnly", validateOnly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.PrepareQueryRequest
  ) extends zio.aws.timestreamquery.model.PrepareQueryRequest.ReadOnly {
    override val queryString: QueryString =
      zio.aws.timestreamquery.model.primitives.QueryString(impl.queryString())
    override val validateOnly: Option[NullableBoolean] = scala
      .Option(impl.validateOnly())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.NullableBoolean(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.PrepareQueryRequest
  ): zio.aws.timestreamquery.model.PrepareQueryRequest.ReadOnly = new Wrapper(
    impl
  )
}
