package zio.aws.timestreamquery.model
import scala.jdk.CollectionConverters._
sealed trait DimensionValueType {
  def unwrap
      : software.amazon.awssdk.services.timestreamquery.model.DimensionValueType
}
object DimensionValueType {
  def wrap(
      value: software.amazon.awssdk.services.timestreamquery.model.DimensionValueType
  ): zio.aws.timestreamquery.model.DimensionValueType = value match {
    case software.amazon.awssdk.services.timestreamquery.model.DimensionValueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.timestreamquery.model.DimensionValueType.VARCHAR =>
      val r = VARCHAR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.timestreamquery.model.DimensionValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.DimensionValueType =
      software.amazon.awssdk.services.timestreamquery.model.DimensionValueType.UNKNOWN_TO_SDK_VERSION
  }
  case object VARCHAR extends zio.aws.timestreamquery.model.DimensionValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.DimensionValueType =
      software.amazon.awssdk.services.timestreamquery.model.DimensionValueType.VARCHAR
  }
}
