package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ColumnInfo(
    name: Option[String] = None,
    `type`: zio.aws.timestreamquery.model.Type
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.ColumnInfo = {
    import ColumnInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.ColumnInfo
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .`type`(`type`.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.ColumnInfo.ReadOnly =
    zio.aws.timestreamquery.model.ColumnInfo.wrap(buildAwsValue())
}
object ColumnInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.ColumnInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.ColumnInfo =
      zio.aws.timestreamquery.model
        .ColumnInfo(name.map(value => value), `type`.asEditable)
    def name: Option[String]
    def `type`: zio.aws.timestreamquery.model.Type.ReadOnly
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getType
        : ZIO[Any, Nothing, zio.aws.timestreamquery.model.Type.ReadOnly] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.ColumnInfo
  ) extends zio.aws.timestreamquery.model.ColumnInfo.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val `type`: zio.aws.timestreamquery.model.Type.ReadOnly =
      zio.aws.timestreamquery.model.Type.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.ColumnInfo
  ): zio.aws.timestreamquery.model.ColumnInfo.ReadOnly = new Wrapper(impl)
}
