package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.QueryId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelQueryRequest(queryId: QueryId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.CancelQueryRequest = {
    import CancelQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.CancelQueryRequest
      .builder()
      .queryId(QueryId.unwrap(queryId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.CancelQueryRequest.ReadOnly =
    zio.aws.timestreamquery.model.CancelQueryRequest.wrap(buildAwsValue())
}
object CancelQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.CancelQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.CancelQueryRequest =
      zio.aws.timestreamquery.model.CancelQueryRequest(queryId)
    def queryId: QueryId
    def getQueryId: ZIO[Any, Nothing, QueryId] = ZIO.succeed(queryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.CancelQueryRequest
  ) extends zio.aws.timestreamquery.model.CancelQueryRequest.ReadOnly {
    override val queryId: QueryId =
      zio.aws.timestreamquery.model.primitives.QueryId(impl.queryId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.CancelQueryRequest
  ): zio.aws.timestreamquery.model.CancelQueryRequest.ReadOnly = new Wrapper(
    impl
  )
}
