package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.SchemaName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MultiMeasureMappings(
    targetMultiMeasureName: Option[SchemaName] = None,
    multiMeasureAttributeMappings: Iterable[
      zio.aws.timestreamquery.model.MultiMeasureAttributeMapping
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.MultiMeasureMappings = {
    import MultiMeasureMappings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.MultiMeasureMappings
      .builder()
      .optionallyWith(
        targetMultiMeasureName.map(value =>
          SchemaName.unwrap(value): java.lang.String
        )
      )(_.targetMultiMeasureName)
      .multiMeasureAttributeMappings(multiMeasureAttributeMappings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.MultiMeasureMappings.ReadOnly =
    zio.aws.timestreamquery.model.MultiMeasureMappings.wrap(buildAwsValue())
}
object MultiMeasureMappings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.MultiMeasureMappings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.MultiMeasureMappings =
      zio.aws.timestreamquery.model.MultiMeasureMappings(
        targetMultiMeasureName.map(value => value),
        multiMeasureAttributeMappings.map { item =>
          item.asEditable
        }
      )
    def targetMultiMeasureName: Option[SchemaName]
    def multiMeasureAttributeMappings: List[
      zio.aws.timestreamquery.model.MultiMeasureAttributeMapping.ReadOnly
    ]
    def getTargetMultiMeasureName: ZIO[Any, AwsError, SchemaName] = AwsError
      .unwrapOptionField("targetMultiMeasureName", targetMultiMeasureName)
    def getMultiMeasureAttributeMappings: ZIO[Any, Nothing, List[
      zio.aws.timestreamquery.model.MultiMeasureAttributeMapping.ReadOnly
    ]] = ZIO.succeed(multiMeasureAttributeMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.MultiMeasureMappings
  ) extends zio.aws.timestreamquery.model.MultiMeasureMappings.ReadOnly {
    override val targetMultiMeasureName: Option[SchemaName] = scala
      .Option(impl.targetMultiMeasureName())
      .map(value => zio.aws.timestreamquery.model.primitives.SchemaName(value))
    override val multiMeasureAttributeMappings: List[
      zio.aws.timestreamquery.model.MultiMeasureAttributeMapping.ReadOnly
    ] = impl
      .multiMeasureAttributeMappings()
      .asScala
      .map { item =>
        zio.aws.timestreamquery.model.MultiMeasureAttributeMapping.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.MultiMeasureMappings
  ): zio.aws.timestreamquery.model.MultiMeasureMappings.ReadOnly = new Wrapper(
    impl
  )
}
