package zio.aws.timestreamquery.model
import scala.jdk.CollectionConverters._
sealed trait MeasureValueType {
  def unwrap
      : software.amazon.awssdk.services.timestreamquery.model.MeasureValueType
}
object MeasureValueType {
  def wrap(
      value: software.amazon.awssdk.services.timestreamquery.model.MeasureValueType
  ): zio.aws.timestreamquery.model.MeasureValueType = value match {
    case software.amazon.awssdk.services.timestreamquery.model.MeasureValueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.timestreamquery.model.MeasureValueType.BIGINT =>
      val r = BIGINT
      r
    case software.amazon.awssdk.services.timestreamquery.model.MeasureValueType.BOOLEAN =>
      val r = BOOLEAN
      r
    case software.amazon.awssdk.services.timestreamquery.model.MeasureValueType.DOUBLE =>
      val r = DOUBLE
      r
    case software.amazon.awssdk.services.timestreamquery.model.MeasureValueType.VARCHAR =>
      val r = VARCHAR
      r
    case software.amazon.awssdk.services.timestreamquery.model.MeasureValueType.MULTI =>
      val r = MULTI
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.timestreamquery.model.MeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.MeasureValueType =
      software.amazon.awssdk.services.timestreamquery.model.MeasureValueType.UNKNOWN_TO_SDK_VERSION
  }
  case object BIGINT extends zio.aws.timestreamquery.model.MeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.MeasureValueType =
      software.amazon.awssdk.services.timestreamquery.model.MeasureValueType.BIGINT
  }
  case object BOOLEAN extends zio.aws.timestreamquery.model.MeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.MeasureValueType =
      software.amazon.awssdk.services.timestreamquery.model.MeasureValueType.BOOLEAN
  }
  case object DOUBLE extends zio.aws.timestreamquery.model.MeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.MeasureValueType =
      software.amazon.awssdk.services.timestreamquery.model.MeasureValueType.DOUBLE
  }
  case object VARCHAR extends zio.aws.timestreamquery.model.MeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.MeasureValueType =
      software.amazon.awssdk.services.timestreamquery.model.MeasureValueType.VARCHAR
  }
  case object MULTI extends zio.aws.timestreamquery.model.MeasureValueType {
    override def unwrap
        : software.amazon.awssdk.services.timestreamquery.model.MeasureValueType =
      software.amazon.awssdk.services.timestreamquery.model.MeasureValueType.MULTI
  }
}
