package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ErrorReportConfiguration(
    s3Configuration: zio.aws.timestreamquery.model.S3Configuration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.ErrorReportConfiguration = {
    import ErrorReportConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.ErrorReportConfiguration
      .builder()
      .s3Configuration(s3Configuration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.ErrorReportConfiguration.ReadOnly =
    zio.aws.timestreamquery.model.ErrorReportConfiguration.wrap(buildAwsValue())
}
object ErrorReportConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.ErrorReportConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.ErrorReportConfiguration =
      zio.aws.timestreamquery.model
        .ErrorReportConfiguration(s3Configuration.asEditable)
    def s3Configuration: zio.aws.timestreamquery.model.S3Configuration.ReadOnly
    def getS3Configuration: ZIO[
      Any,
      Nothing,
      zio.aws.timestreamquery.model.S3Configuration.ReadOnly
    ] = ZIO.succeed(s3Configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.ErrorReportConfiguration
  ) extends zio.aws.timestreamquery.model.ErrorReportConfiguration.ReadOnly {
    override val s3Configuration
        : zio.aws.timestreamquery.model.S3Configuration.ReadOnly =
      zio.aws.timestreamquery.model.S3Configuration.wrap(impl.s3Configuration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.ErrorReportConfiguration
  ): zio.aws.timestreamquery.model.ErrorReportConfiguration.ReadOnly =
    new Wrapper(impl)
}
