package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelQueryResponse(
    cancellationMessage: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.CancelQueryResponse = {
    import CancelQueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.CancelQueryResponse
      .builder()
      .optionallyWith(
        cancellationMessage.map(value => value: java.lang.String)
      )(_.cancellationMessage)
      .build()
  }
  def asReadOnly: zio.aws.timestreamquery.model.CancelQueryResponse.ReadOnly =
    zio.aws.timestreamquery.model.CancelQueryResponse.wrap(buildAwsValue())
}
object CancelQueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.CancelQueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.CancelQueryResponse =
      zio.aws.timestreamquery.model
        .CancelQueryResponse(cancellationMessage.map(value => value))
    def cancellationMessage: Option[String]
    def getCancellationMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cancellationMessage", cancellationMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.CancelQueryResponse
  ) extends zio.aws.timestreamquery.model.CancelQueryResponse.ReadOnly {
    override val cancellationMessage: Option[String] =
      scala.Option(impl.cancellationMessage()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.CancelQueryResponse
  ): zio.aws.timestreamquery.model.CancelQueryResponse.ReadOnly = new Wrapper(
    impl
  )
}
