package zio.aws.timestreamquery.model
import zio.ZIO
import zio.aws.timestreamquery.model.primitives.{
  StringValue2048,
  ScheduledQueryName,
  AmazonResourceName,
  ClientToken,
  QueryString
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateScheduledQueryRequest(
    name: ScheduledQueryName,
    queryString: QueryString,
    scheduleConfiguration: zio.aws.timestreamquery.model.ScheduleConfiguration,
    notificationConfiguration: zio.aws.timestreamquery.model.NotificationConfiguration,
    targetConfiguration: Option[
      zio.aws.timestreamquery.model.TargetConfiguration
    ] = None,
    clientToken: Option[ClientToken] = None,
    scheduledQueryExecutionRoleArn: AmazonResourceName,
    tags: Option[Iterable[zio.aws.timestreamquery.model.Tag]] = None,
    kmsKeyId: Option[StringValue2048] = None,
    errorReportConfiguration: zio.aws.timestreamquery.model.ErrorReportConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryRequest = {
    import CreateScheduledQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryRequest
      .builder()
      .name(ScheduledQueryName.unwrap(name): java.lang.String)
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .scheduleConfiguration(scheduleConfiguration.buildAwsValue())
      .notificationConfiguration(notificationConfiguration.buildAwsValue())
      .optionallyWith(targetConfiguration.map(value => value.buildAwsValue()))(
        _.targetConfiguration
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .scheduledQueryExecutionRoleArn(
        AmazonResourceName.unwrap(
          scheduledQueryExecutionRoleArn
        ): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        kmsKeyId.map(value => StringValue2048.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .errorReportConfiguration(errorReportConfiguration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.timestreamquery.model.CreateScheduledQueryRequest.ReadOnly =
    zio.aws.timestreamquery.model.CreateScheduledQueryRequest
      .wrap(buildAwsValue())
}
object CreateScheduledQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.timestreamquery.model.CreateScheduledQueryRequest =
      zio.aws.timestreamquery.model.CreateScheduledQueryRequest(
        name,
        queryString,
        scheduleConfiguration.asEditable,
        notificationConfiguration.asEditable,
        targetConfiguration.map(value => value.asEditable),
        clientToken.map(value => value),
        scheduledQueryExecutionRoleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        errorReportConfiguration.asEditable
      )
    def name: ScheduledQueryName
    def queryString: QueryString
    def scheduleConfiguration
        : zio.aws.timestreamquery.model.ScheduleConfiguration.ReadOnly
    def notificationConfiguration
        : zio.aws.timestreamquery.model.NotificationConfiguration.ReadOnly
    def targetConfiguration
        : Option[zio.aws.timestreamquery.model.TargetConfiguration.ReadOnly]
    def clientToken: Option[ClientToken]
    def scheduledQueryExecutionRoleArn: AmazonResourceName
    def tags: Option[List[zio.aws.timestreamquery.model.Tag.ReadOnly]]
    def kmsKeyId: Option[StringValue2048]
    def errorReportConfiguration
        : zio.aws.timestreamquery.model.ErrorReportConfiguration.ReadOnly
    def getName: ZIO[Any, Nothing, ScheduledQueryName] = ZIO.succeed(name)
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getScheduleConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.timestreamquery.model.ScheduleConfiguration.ReadOnly
    ] = ZIO.succeed(scheduleConfiguration)
    def getNotificationConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.timestreamquery.model.NotificationConfiguration.ReadOnly
    ] = ZIO.succeed(notificationConfiguration)
    def getTargetConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.timestreamquery.model.TargetConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("targetConfiguration", targetConfiguration)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getScheduledQueryExecutionRoleArn
        : ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(scheduledQueryExecutionRoleArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.timestreamquery.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, StringValue2048] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getErrorReportConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.timestreamquery.model.ErrorReportConfiguration.ReadOnly
    ] = ZIO.succeed(errorReportConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryRequest
  ) extends zio.aws.timestreamquery.model.CreateScheduledQueryRequest.ReadOnly {
    override val name: ScheduledQueryName =
      zio.aws.timestreamquery.model.primitives.ScheduledQueryName(impl.name())
    override val queryString: QueryString =
      zio.aws.timestreamquery.model.primitives.QueryString(impl.queryString())
    override val scheduleConfiguration
        : zio.aws.timestreamquery.model.ScheduleConfiguration.ReadOnly =
      zio.aws.timestreamquery.model.ScheduleConfiguration
        .wrap(impl.scheduleConfiguration())
    override val notificationConfiguration
        : zio.aws.timestreamquery.model.NotificationConfiguration.ReadOnly =
      zio.aws.timestreamquery.model.NotificationConfiguration
        .wrap(impl.notificationConfiguration())
    override val targetConfiguration
        : Option[zio.aws.timestreamquery.model.TargetConfiguration.ReadOnly] =
      scala
        .Option(impl.targetConfiguration())
        .map(value =>
          zio.aws.timestreamquery.model.TargetConfiguration.wrap(value)
        )
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.timestreamquery.model.primitives.ClientToken(value))
    override val scheduledQueryExecutionRoleArn: AmazonResourceName =
      zio.aws.timestreamquery.model.primitives
        .AmazonResourceName(impl.scheduledQueryExecutionRoleArn())
    override val tags
        : Option[List[zio.aws.timestreamquery.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.timestreamquery.model.Tag.wrap(item)
        }.toList
      )
    override val kmsKeyId: Option[StringValue2048] = scala
      .Option(impl.kmsKeyId())
      .map(value =>
        zio.aws.timestreamquery.model.primitives.StringValue2048(value)
      )
    override val errorReportConfiguration
        : zio.aws.timestreamquery.model.ErrorReportConfiguration.ReadOnly =
      zio.aws.timestreamquery.model.ErrorReportConfiguration
        .wrap(impl.errorReportConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryRequest
  ): zio.aws.timestreamquery.model.CreateScheduledQueryRequest.ReadOnly =
    new Wrapper(impl)
}
