package zio.aws.textract.model
import scala.jdk.CollectionConverters.*
sealed trait FeatureType {
  def unwrap: software.amazon.awssdk.services.textract.model.FeatureType
}
object FeatureType {
  def wrap(
      value: software.amazon.awssdk.services.textract.model.FeatureType
  ): zio.aws.textract.model.FeatureType = value match {
    case software.amazon.awssdk.services.textract.model.FeatureType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.textract.model.FeatureType.TABLES =>
      val r = TABLES
      r
    case software.amazon.awssdk.services.textract.model.FeatureType.FORMS =>
      val r = FORMS
      r
    case software.amazon.awssdk.services.textract.model.FeatureType.QUERIES =>
      val r = QUERIES
      r
    case software.amazon.awssdk.services.textract.model.FeatureType.SIGNATURES =>
      val r = SIGNATURES
      r
    case software.amazon.awssdk.services.textract.model.FeatureType.LAYOUT =>
      val r = LAYOUT
      r
  }
  case object unknownToSdkVersion extends zio.aws.textract.model.FeatureType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.FeatureType =
      software.amazon.awssdk.services.textract.model.FeatureType.UNKNOWN_TO_SDK_VERSION
  }
  case object TABLES extends zio.aws.textract.model.FeatureType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.FeatureType =
      software.amazon.awssdk.services.textract.model.FeatureType.TABLES
  }
  case object FORMS extends zio.aws.textract.model.FeatureType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.FeatureType =
      software.amazon.awssdk.services.textract.model.FeatureType.FORMS
  }
  case object QUERIES extends zio.aws.textract.model.FeatureType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.FeatureType =
      software.amazon.awssdk.services.textract.model.FeatureType.QUERIES
  }
  case object SIGNATURES extends zio.aws.textract.model.FeatureType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.FeatureType =
      software.amazon.awssdk.services.textract.model.FeatureType.SIGNATURES
  }
  case object LAYOUT extends zio.aws.textract.model.FeatureType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.FeatureType =
      software.amazon.awssdk.services.textract.model.FeatureType.LAYOUT
  }
}
