package zio.aws.textract
import zio.aws.textract.model.DetectDocumentTextResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.textract.model.{
  ListAdaptersRequest,
  StartExpenseAnalysisResponse,
  StartDocumentTextDetectionRequest,
  AnalyzeIdResponse,
  StartDocumentAnalysisResponse,
  GetDocumentAnalysisRequest,
  Block,
  AnalyzeExpenseRequest,
  GetDocumentTextDetectionRequest,
  GetAdapterVersionRequest,
  GetAdapterResponse,
  GetLendingAnalysisSummaryRequest,
  AdapterVersionOverview,
  UpdateAdapterResponse,
  GetLendingAnalysisSummaryResponse,
  GetDocumentTextDetectionResponse,
  AnalyzeIdRequest,
  AdapterOverview,
  AnalyzeExpenseResponse,
  GetLendingAnalysisRequest,
  StartLendingAnalysisRequest,
  ListTagsForResourceRequest,
  UpdateAdapterRequest,
  ListAdapterVersionsRequest,
  CreateAdapterRequest,
  CreateAdapterVersionRequest,
  DeleteAdapterVersionRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetExpenseAnalysisResponse,
  StartDocumentTextDetectionResponse,
  DeleteAdapterVersionResponse,
  StartDocumentAnalysisRequest,
  StartLendingAnalysisResponse,
  DetectDocumentTextRequest,
  DeleteAdapterRequest,
  ListAdaptersResponse,
  GetAdapterRequest,
  GetDocumentAnalysisResponse,
  AnalyzeDocumentRequest,
  GetExpenseAnalysisRequest,
  UntagResourceRequest,
  DeleteAdapterResponse,
  GetAdapterVersionResponse,
  CreateAdapterVersionResponse,
  ListAdapterVersionsResponse,
  GetLendingAnalysisResponse,
  AnalyzeDocumentResponse,
  CreateAdapterResponse,
  StartExpenseAnalysisRequest,
  TagResourceResponse,
  DetectDocumentTextResponse,
  TagResourceRequest
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.textract.{
  TextractAsyncClientBuilder,
  TextractAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Textract extends AspectSupport[Textract] {
  val api: TextractAsyncClient
  def deleteAdapter(
      request: zio.aws.textract.model.DeleteAdapterRequest
  ): IO[AwsError, zio.aws.textract.model.DeleteAdapterResponse.ReadOnly]
  def startExpenseAnalysis(
      request: zio.aws.textract.model.StartExpenseAnalysisRequest
  ): IO[AwsError, zio.aws.textract.model.StartExpenseAnalysisResponse.ReadOnly]
  def getDocumentAnalysis(
      request: zio.aws.textract.model.GetDocumentAnalysisRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly,
    zio.aws.textract.model.Block.ReadOnly
  ]]
  def getDocumentAnalysisPaginated(
      request: zio.aws.textract.model.GetDocumentAnalysisRequest
  ): IO[AwsError, zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly]
  def updateAdapter(
      request: zio.aws.textract.model.UpdateAdapterRequest
  ): IO[AwsError, zio.aws.textract.model.UpdateAdapterResponse.ReadOnly]
  def getLendingAnalysisSummary(
      request: zio.aws.textract.model.GetLendingAnalysisSummaryRequest
  ): IO[
    AwsError,
    zio.aws.textract.model.GetLendingAnalysisSummaryResponse.ReadOnly
  ]
  def analyzeExpense(
      request: zio.aws.textract.model.AnalyzeExpenseRequest
  ): IO[AwsError, zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly]
  def createAdapter(
      request: zio.aws.textract.model.CreateAdapterRequest
  ): IO[AwsError, zio.aws.textract.model.CreateAdapterResponse.ReadOnly]
  def startLendingAnalysis(
      request: zio.aws.textract.model.StartLendingAnalysisRequest
  ): IO[AwsError, zio.aws.textract.model.StartLendingAnalysisResponse.ReadOnly]
  def getAdapter(
      request: zio.aws.textract.model.GetAdapterRequest
  ): IO[AwsError, zio.aws.textract.model.GetAdapterResponse.ReadOnly]
  def detectDocumentText(
      request: zio.aws.textract.model.DetectDocumentTextRequest
  ): IO[AwsError, ReadOnly]
  def startDocumentAnalysis(
      request: zio.aws.textract.model.StartDocumentAnalysisRequest
  ): IO[AwsError, zio.aws.textract.model.StartDocumentAnalysisResponse.ReadOnly]
  def analyzeDocument(
      request: zio.aws.textract.model.AnalyzeDocumentRequest
  ): IO[AwsError, zio.aws.textract.model.AnalyzeDocumentResponse.ReadOnly]
  def getExpenseAnalysis(
      request: zio.aws.textract.model.GetExpenseAnalysisRequest
  ): IO[AwsError, zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly]
  def createAdapterVersion(
      request: zio.aws.textract.model.CreateAdapterVersionRequest
  ): IO[AwsError, zio.aws.textract.model.CreateAdapterVersionResponse.ReadOnly]
  def listAdapterVersions(
      request: zio.aws.textract.model.ListAdapterVersionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.textract.model.AdapterVersionOverview.ReadOnly
  ]
  def listAdapterVersionsPaginated(
      request: zio.aws.textract.model.ListAdapterVersionsRequest
  ): IO[AwsError, zio.aws.textract.model.ListAdapterVersionsResponse.ReadOnly]
  def untagResource(
      request: zio.aws.textract.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.textract.model.UntagResourceResponse.ReadOnly]
  def analyzeID(
      request: zio.aws.textract.model.AnalyzeIdRequest
  ): IO[AwsError, zio.aws.textract.model.AnalyzeIdResponse.ReadOnly]
  def getLendingAnalysis(
      request: zio.aws.textract.model.GetLendingAnalysisRequest
  ): IO[AwsError, zio.aws.textract.model.GetLendingAnalysisResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.textract.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.textract.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: zio.aws.textract.model.TagResourceRequest
  ): IO[AwsError, zio.aws.textract.model.TagResourceResponse.ReadOnly]
  def getAdapterVersion(
      request: zio.aws.textract.model.GetAdapterVersionRequest
  ): IO[AwsError, zio.aws.textract.model.GetAdapterVersionResponse.ReadOnly]
  def startDocumentTextDetection(
      request: zio.aws.textract.model.StartDocumentTextDetectionRequest
  ): IO[
    AwsError,
    zio.aws.textract.model.StartDocumentTextDetectionResponse.ReadOnly
  ]
  def getDocumentTextDetection(
      request: zio.aws.textract.model.GetDocumentTextDetectionRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly,
    zio.aws.textract.model.Block.ReadOnly
  ]]
  def getDocumentTextDetectionPaginated(
      request: zio.aws.textract.model.GetDocumentTextDetectionRequest
  ): IO[
    AwsError,
    zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly
  ]
  def deleteAdapterVersion(
      request: zio.aws.textract.model.DeleteAdapterVersionRequest
  ): IO[AwsError, zio.aws.textract.model.DeleteAdapterVersionResponse.ReadOnly]
  def listAdapters(
      request: zio.aws.textract.model.ListAdaptersRequest
  ): ZStream[Any, AwsError, zio.aws.textract.model.AdapterOverview.ReadOnly]
  def listAdaptersPaginated(
      request: zio.aws.textract.model.ListAdaptersRequest
  ): IO[AwsError, zio.aws.textract.model.ListAdaptersResponse.ReadOnly]
}
object Textract {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Textract] = customized(
    identity
  )
  def customized(
      customization: TextractAsyncClientBuilder => TextractAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Textract] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: TextractAsyncClientBuilder => TextractAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Textract] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = TextractAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[TextractAsyncClient, TextractAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[TextractAsyncClient, TextractAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new TextractImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class TextractImpl[R](
      override val api: TextractAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Textract
      with AwsServiceBase[R] {
    override val serviceName: String = "Textract"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): TextractImpl[R1] = new TextractImpl(api, newAspect, r)
    def deleteAdapter(
        request: zio.aws.textract.model.DeleteAdapterRequest
    ): IO[AwsError, zio.aws.textract.model.DeleteAdapterResponse.ReadOnly] =
      asyncRequestResponse[DeleteAdapterRequest, DeleteAdapterResponse](
        "deleteAdapter",
        api.deleteAdapter
      )(request.buildAwsValue())
        .map(zio.aws.textract.model.DeleteAdapterResponse.wrap)
        .provideEnvironment(r)
    def startExpenseAnalysis(
        request: zio.aws.textract.model.StartExpenseAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.StartExpenseAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      StartExpenseAnalysisRequest,
      StartExpenseAnalysisResponse
    ]("startExpenseAnalysis", api.startExpenseAnalysis)(request.buildAwsValue())
      .map(zio.aws.textract.model.StartExpenseAnalysisResponse.wrap)
      .provideEnvironment(r)
    def getDocumentAnalysis(
        request: zio.aws.textract.model.GetDocumentAnalysisRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly,
      zio.aws.textract.model.Block.ReadOnly
    ]] = asyncPaginatedRequest[
      GetDocumentAnalysisRequest,
      GetDocumentAnalysisResponse,
      Block
    ](
      "getDocumentAnalysis",
      api.getDocumentAnalysis,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.blocks().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.textract.model.GetDocumentAnalysisResponse.wrap)
          .mapOutput(_.map(item => zio.aws.textract.model.Block.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getDocumentAnalysisPaginated(
        request: zio.aws.textract.model.GetDocumentAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDocumentAnalysisRequest,
      GetDocumentAnalysisResponse
    ]("getDocumentAnalysis", api.getDocumentAnalysis)(request.buildAwsValue())
      .map(zio.aws.textract.model.GetDocumentAnalysisResponse.wrap)
      .provideEnvironment(r)
    def updateAdapter(
        request: zio.aws.textract.model.UpdateAdapterRequest
    ): IO[AwsError, zio.aws.textract.model.UpdateAdapterResponse.ReadOnly] =
      asyncRequestResponse[UpdateAdapterRequest, UpdateAdapterResponse](
        "updateAdapter",
        api.updateAdapter
      )(request.buildAwsValue())
        .map(zio.aws.textract.model.UpdateAdapterResponse.wrap)
        .provideEnvironment(r)
    def getLendingAnalysisSummary(
        request: zio.aws.textract.model.GetLendingAnalysisSummaryRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.GetLendingAnalysisSummaryResponse.ReadOnly
    ] = asyncRequestResponse[
      GetLendingAnalysisSummaryRequest,
      GetLendingAnalysisSummaryResponse
    ]("getLendingAnalysisSummary", api.getLendingAnalysisSummary)(
      request.buildAwsValue()
    ).map(zio.aws.textract.model.GetLendingAnalysisSummaryResponse.wrap)
      .provideEnvironment(r)
    def analyzeExpense(
        request: zio.aws.textract.model.AnalyzeExpenseRequest
    ): IO[AwsError, zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly] =
      asyncRequestResponse[AnalyzeExpenseRequest, AnalyzeExpenseResponse](
        "analyzeExpense",
        api.analyzeExpense
      )(request.buildAwsValue())
        .map(zio.aws.textract.model.AnalyzeExpenseResponse.wrap)
        .provideEnvironment(r)
    def createAdapter(
        request: zio.aws.textract.model.CreateAdapterRequest
    ): IO[AwsError, zio.aws.textract.model.CreateAdapterResponse.ReadOnly] =
      asyncRequestResponse[CreateAdapterRequest, CreateAdapterResponse](
        "createAdapter",
        api.createAdapter
      )(request.buildAwsValue())
        .map(zio.aws.textract.model.CreateAdapterResponse.wrap)
        .provideEnvironment(r)
    def startLendingAnalysis(
        request: zio.aws.textract.model.StartLendingAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.StartLendingAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      StartLendingAnalysisRequest,
      StartLendingAnalysisResponse
    ]("startLendingAnalysis", api.startLendingAnalysis)(request.buildAwsValue())
      .map(zio.aws.textract.model.StartLendingAnalysisResponse.wrap)
      .provideEnvironment(r)
    def getAdapter(
        request: zio.aws.textract.model.GetAdapterRequest
    ): IO[AwsError, zio.aws.textract.model.GetAdapterResponse.ReadOnly] =
      asyncRequestResponse[GetAdapterRequest, GetAdapterResponse](
        "getAdapter",
        api.getAdapter
      )(request.buildAwsValue())
        .map(zio.aws.textract.model.GetAdapterResponse.wrap)
        .provideEnvironment(r)
    def detectDocumentText(
        request: zio.aws.textract.model.DetectDocumentTextRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      DetectDocumentTextRequest,
      DetectDocumentTextResponse
    ]("detectDocumentText", api.detectDocumentText)(request.buildAwsValue())
      .map(zio.aws.textract.model.DetectDocumentTextResponse.wrap)
      .provideEnvironment(r)
    def startDocumentAnalysis(
        request: zio.aws.textract.model.StartDocumentAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.StartDocumentAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      StartDocumentAnalysisRequest,
      StartDocumentAnalysisResponse
    ]("startDocumentAnalysis", api.startDocumentAnalysis)(
      request.buildAwsValue()
    ).map(zio.aws.textract.model.StartDocumentAnalysisResponse.wrap)
      .provideEnvironment(r)
    def analyzeDocument(
        request: zio.aws.textract.model.AnalyzeDocumentRequest
    ): IO[AwsError, zio.aws.textract.model.AnalyzeDocumentResponse.ReadOnly] =
      asyncRequestResponse[AnalyzeDocumentRequest, AnalyzeDocumentResponse](
        "analyzeDocument",
        api.analyzeDocument
      )(request.buildAwsValue())
        .map(zio.aws.textract.model.AnalyzeDocumentResponse.wrap)
        .provideEnvironment(r)
    def getExpenseAnalysis(
        request: zio.aws.textract.model.GetExpenseAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      GetExpenseAnalysisRequest,
      GetExpenseAnalysisResponse
    ]("getExpenseAnalysis", api.getExpenseAnalysis)(request.buildAwsValue())
      .map(zio.aws.textract.model.GetExpenseAnalysisResponse.wrap)
      .provideEnvironment(r)
    def createAdapterVersion(
        request: zio.aws.textract.model.CreateAdapterVersionRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.CreateAdapterVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateAdapterVersionRequest,
      CreateAdapterVersionResponse
    ]("createAdapterVersion", api.createAdapterVersion)(request.buildAwsValue())
      .map(zio.aws.textract.model.CreateAdapterVersionResponse.wrap)
      .provideEnvironment(r)
    def listAdapterVersions(
        request: zio.aws.textract.model.ListAdapterVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.textract.model.AdapterVersionOverview.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListAdapterVersionsRequest,
      ListAdapterVersionsResponse,
      AdapterVersionOverview
    ](
      "listAdapterVersions",
      api.listAdapterVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.adapterVersions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.textract.model.AdapterVersionOverview.wrap(item))
      .provideEnvironment(r)
    def listAdapterVersionsPaginated(
        request: zio.aws.textract.model.ListAdapterVersionsRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.ListAdapterVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListAdapterVersionsRequest,
      ListAdapterVersionsResponse
    ]("listAdapterVersions", api.listAdapterVersions)(request.buildAwsValue())
      .map(zio.aws.textract.model.ListAdapterVersionsResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.textract.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.textract.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.textract.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def analyzeID(
        request: zio.aws.textract.model.AnalyzeIdRequest
    ): IO[AwsError, zio.aws.textract.model.AnalyzeIdResponse.ReadOnly] =
      asyncRequestResponse[AnalyzeIdRequest, AnalyzeIdResponse](
        "analyzeID",
        api.analyzeID
      )(request.buildAwsValue())
        .map(zio.aws.textract.model.AnalyzeIdResponse.wrap)
        .provideEnvironment(r)
    def getLendingAnalysis(
        request: zio.aws.textract.model.GetLendingAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.GetLendingAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      GetLendingAnalysisRequest,
      GetLendingAnalysisResponse
    ]("getLendingAnalysis", api.getLendingAnalysis)(request.buildAwsValue())
      .map(zio.aws.textract.model.GetLendingAnalysisResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.textract.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.textract.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.textract.model.TagResourceRequest
    ): IO[AwsError, zio.aws.textract.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.textract.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getAdapterVersion(
        request: zio.aws.textract.model.GetAdapterVersionRequest
    ): IO[AwsError, zio.aws.textract.model.GetAdapterVersionResponse.ReadOnly] =
      asyncRequestResponse[GetAdapterVersionRequest, GetAdapterVersionResponse](
        "getAdapterVersion",
        api.getAdapterVersion
      )(request.buildAwsValue())
        .map(zio.aws.textract.model.GetAdapterVersionResponse.wrap)
        .provideEnvironment(r)
    def startDocumentTextDetection(
        request: zio.aws.textract.model.StartDocumentTextDetectionRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.StartDocumentTextDetectionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartDocumentTextDetectionRequest,
      StartDocumentTextDetectionResponse
    ]("startDocumentTextDetection", api.startDocumentTextDetection)(
      request.buildAwsValue()
    ).map(zio.aws.textract.model.StartDocumentTextDetectionResponse.wrap)
      .provideEnvironment(r)
    def getDocumentTextDetection(
        request: zio.aws.textract.model.GetDocumentTextDetectionRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly,
      zio.aws.textract.model.Block.ReadOnly
    ]] = asyncPaginatedRequest[
      GetDocumentTextDetectionRequest,
      GetDocumentTextDetectionResponse,
      Block
    ](
      "getDocumentTextDetection",
      api.getDocumentTextDetection,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.blocks().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.textract.model.GetDocumentTextDetectionResponse.wrap
          )
          .mapOutput(_.map(item => zio.aws.textract.model.Block.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getDocumentTextDetectionPaginated(
        request: zio.aws.textract.model.GetDocumentTextDetectionRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDocumentTextDetectionRequest,
      GetDocumentTextDetectionResponse
    ]("getDocumentTextDetection", api.getDocumentTextDetection)(
      request.buildAwsValue()
    ).map(zio.aws.textract.model.GetDocumentTextDetectionResponse.wrap)
      .provideEnvironment(r)
    def deleteAdapterVersion(
        request: zio.aws.textract.model.DeleteAdapterVersionRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.DeleteAdapterVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteAdapterVersionRequest,
      DeleteAdapterVersionResponse
    ]("deleteAdapterVersion", api.deleteAdapterVersion)(request.buildAwsValue())
      .map(zio.aws.textract.model.DeleteAdapterVersionResponse.wrap)
      .provideEnvironment(r)
    def listAdapters(
        request: zio.aws.textract.model.ListAdaptersRequest
    ): ZStream[Any, AwsError, zio.aws.textract.model.AdapterOverview.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListAdaptersRequest,
        ListAdaptersResponse,
        AdapterOverview
      ](
        "listAdapters",
        api.listAdapters,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.adapters().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.textract.model.AdapterOverview.wrap(item))
        .provideEnvironment(r)
    def listAdaptersPaginated(
        request: zio.aws.textract.model.ListAdaptersRequest
    ): IO[AwsError, zio.aws.textract.model.ListAdaptersResponse.ReadOnly] =
      asyncRequestResponse[ListAdaptersRequest, ListAdaptersResponse](
        "listAdapters",
        api.listAdapters
      )(request.buildAwsValue())
        .map(zio.aws.textract.model.ListAdaptersResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteAdapter(request: zio.aws.textract.model.DeleteAdapterRequest): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.DeleteAdapterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAdapter(request))
  def startExpenseAnalysis(
      request: zio.aws.textract.model.StartExpenseAnalysisRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.StartExpenseAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startExpenseAnalysis(request))
  def getDocumentAnalysis(
      request: zio.aws.textract.model.GetDocumentAnalysisRequest
  ): ZIO[zio.aws.textract.Textract, AwsError, StreamingOutputResult[
    Any,
    zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly,
    zio.aws.textract.model.Block.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getDocumentAnalysis(request))
  def getDocumentAnalysisPaginated(
      request: zio.aws.textract.model.GetDocumentAnalysisRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDocumentAnalysisPaginated(request))
  def updateAdapter(request: zio.aws.textract.model.UpdateAdapterRequest): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.UpdateAdapterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAdapter(request))
  def getLendingAnalysisSummary(
      request: zio.aws.textract.model.GetLendingAnalysisSummaryRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.GetLendingAnalysisSummaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLendingAnalysisSummary(request))
  def analyzeExpense(
      request: zio.aws.textract.model.AnalyzeExpenseRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.analyzeExpense(request))
  def createAdapter(request: zio.aws.textract.model.CreateAdapterRequest): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.CreateAdapterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAdapter(request))
  def startLendingAnalysis(
      request: zio.aws.textract.model.StartLendingAnalysisRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.StartLendingAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startLendingAnalysis(request))
  def getAdapter(request: zio.aws.textract.model.GetAdapterRequest): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.GetAdapterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAdapter(request))
  def detectDocumentText(
      request: zio.aws.textract.model.DetectDocumentTextRequest
  ): ZIO[zio.aws.textract.Textract, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.detectDocumentText(request))
  def startDocumentAnalysis(
      request: zio.aws.textract.model.StartDocumentAnalysisRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.StartDocumentAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDocumentAnalysis(request))
  def analyzeDocument(
      request: zio.aws.textract.model.AnalyzeDocumentRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.AnalyzeDocumentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.analyzeDocument(request))
  def getExpenseAnalysis(
      request: zio.aws.textract.model.GetExpenseAnalysisRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getExpenseAnalysis(request))
  def createAdapterVersion(
      request: zio.aws.textract.model.CreateAdapterVersionRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.CreateAdapterVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAdapterVersion(request))
  def listAdapterVersions(
      request: zio.aws.textract.model.ListAdapterVersionsRequest
  ): ZStream[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.AdapterVersionOverview.ReadOnly
  ] = ZStream.serviceWithStream(_.listAdapterVersions(request))
  def listAdapterVersionsPaginated(
      request: zio.aws.textract.model.ListAdapterVersionsRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.ListAdapterVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAdapterVersionsPaginated(request))
  def untagResource(request: zio.aws.textract.model.UntagResourceRequest): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def analyzeID(request: zio.aws.textract.model.AnalyzeIdRequest): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.AnalyzeIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.analyzeID(request))
  def getLendingAnalysis(
      request: zio.aws.textract.model.GetLendingAnalysisRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.GetLendingAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLendingAnalysis(request))
  def listTagsForResource(
      request: zio.aws.textract.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: zio.aws.textract.model.TagResourceRequest): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getAdapterVersion(
      request: zio.aws.textract.model.GetAdapterVersionRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.GetAdapterVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAdapterVersion(request))
  def startDocumentTextDetection(
      request: zio.aws.textract.model.StartDocumentTextDetectionRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.StartDocumentTextDetectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDocumentTextDetection(request))
  def getDocumentTextDetection(
      request: zio.aws.textract.model.GetDocumentTextDetectionRequest
  ): ZIO[zio.aws.textract.Textract, AwsError, StreamingOutputResult[
    Any,
    zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly,
    zio.aws.textract.model.Block.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getDocumentTextDetection(request))
  def getDocumentTextDetectionPaginated(
      request: zio.aws.textract.model.GetDocumentTextDetectionRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDocumentTextDetectionPaginated(request))
  def deleteAdapterVersion(
      request: zio.aws.textract.model.DeleteAdapterVersionRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.DeleteAdapterVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAdapterVersion(request))
  def listAdapters(
      request: zio.aws.textract.model.ListAdaptersRequest
  ): ZStream[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.AdapterOverview.ReadOnly
  ] = ZStream.serviceWithStream(_.listAdapters(request))
  def listAdaptersPaginated(
      request: zio.aws.textract.model.ListAdaptersRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.ListAdaptersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAdaptersPaginated(request))
}
