package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.AdapterId
import scala.jdk.CollectionConverters.*
final case class CreateAdapterResponse(
    adapterId: Optional[AdapterId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.CreateAdapterResponse = {
    import CreateAdapterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.CreateAdapterResponse
      .builder()
      .optionallyWith(
        adapterId.map(value => AdapterId.unwrap(value): java.lang.String)
      )(_.adapterId)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.CreateAdapterResponse.ReadOnly =
    zio.aws.textract.model.CreateAdapterResponse.wrap(buildAwsValue())
}
object CreateAdapterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.CreateAdapterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.CreateAdapterResponse =
      zio.aws.textract.model
        .CreateAdapterResponse(adapterId.map(value => value))
    def adapterId: Optional[AdapterId]
    def getAdapterId: ZIO[Any, AwsError, AdapterId] =
      AwsError.unwrapOptionField("adapterId", adapterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.CreateAdapterResponse
  ) extends zio.aws.textract.model.CreateAdapterResponse.ReadOnly {
    override val adapterId: Optional[AdapterId] = zio.aws.core.internal
      .optionalFromNullable(impl.adapterId())
      .map(value => zio.aws.textract.model.primitives.AdapterId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.CreateAdapterResponse
  ): zio.aws.textract.model.CreateAdapterResponse.ReadOnly = new Wrapper(impl)
}
