package zio.aws.textract.model
import scala.jdk.CollectionConverters.*
sealed trait BlockType {
  def unwrap: software.amazon.awssdk.services.textract.model.BlockType
}
object BlockType {
  def wrap(
      value: software.amazon.awssdk.services.textract.model.BlockType
  ): zio.aws.textract.model.BlockType = value match {
    case software.amazon.awssdk.services.textract.model.BlockType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.textract.model.BlockType.KEY_VALUE_SET =>
      val r = KEY_VALUE_SET
      r
    case software.amazon.awssdk.services.textract.model.BlockType.PAGE =>
      val r = PAGE
      r
    case software.amazon.awssdk.services.textract.model.BlockType.LINE =>
      val r = LINE
      r
    case software.amazon.awssdk.services.textract.model.BlockType.WORD =>
      val r = WORD
      r
    case software.amazon.awssdk.services.textract.model.BlockType.TABLE =>
      val r = TABLE
      r
    case software.amazon.awssdk.services.textract.model.BlockType.CELL =>
      val r = CELL
      r
    case software.amazon.awssdk.services.textract.model.BlockType.SELECTION_ELEMENT =>
      val r = SELECTION_ELEMENT
      r
    case software.amazon.awssdk.services.textract.model.BlockType.MERGED_CELL =>
      val r = MERGED_CELL
      r
    case software.amazon.awssdk.services.textract.model.BlockType.TITLE =>
      val r = TITLE
      r
    case software.amazon.awssdk.services.textract.model.BlockType.QUERY =>
      val r = QUERY
      r
    case software.amazon.awssdk.services.textract.model.BlockType.QUERY_RESULT =>
      val r = QUERY_RESULT
      r
    case software.amazon.awssdk.services.textract.model.BlockType.SIGNATURE =>
      val r = SIGNATURE
      r
    case software.amazon.awssdk.services.textract.model.BlockType.TABLE_TITLE =>
      val r = TABLE_TITLE
      r
    case software.amazon.awssdk.services.textract.model.BlockType.TABLE_FOOTER =>
      val r = TABLE_FOOTER
      r
    case software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_TEXT =>
      val r = LAYOUT_TEXT
      r
    case software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_TITLE =>
      val r = LAYOUT_TITLE
      r
    case software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_HEADER =>
      val r = LAYOUT_HEADER
      r
    case software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_FOOTER =>
      val r = LAYOUT_FOOTER
      r
    case software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_SECTION_HEADER =>
      val r = LAYOUT_SECTION_HEADER
      r
    case software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_PAGE_NUMBER =>
      val r = LAYOUT_PAGE_NUMBER
      r
    case software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_LIST =>
      val r = LAYOUT_LIST
      r
    case software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_FIGURE =>
      val r = LAYOUT_FIGURE
      r
    case software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_TABLE =>
      val r = LAYOUT_TABLE
      r
    case software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_KEY_VALUE =>
      val r = LAYOUT_KEY_VALUE
      r
  }
  case object unknownToSdkVersion extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.UNKNOWN_TO_SDK_VERSION
  }
  case object KEY_VALUE_SET extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.KEY_VALUE_SET
  }
  case object PAGE extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.PAGE
  }
  case object LINE extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.LINE
  }
  case object WORD extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.WORD
  }
  case object TABLE extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.TABLE
  }
  case object CELL extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.CELL
  }
  case object SELECTION_ELEMENT extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.SELECTION_ELEMENT
  }
  case object MERGED_CELL extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.MERGED_CELL
  }
  case object TITLE extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.TITLE
  }
  case object QUERY extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.QUERY
  }
  case object QUERY_RESULT extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.QUERY_RESULT
  }
  case object SIGNATURE extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.SIGNATURE
  }
  case object TABLE_TITLE extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.TABLE_TITLE
  }
  case object TABLE_FOOTER extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.TABLE_FOOTER
  }
  case object LAYOUT_TEXT extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_TEXT
  }
  case object LAYOUT_TITLE extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_TITLE
  }
  case object LAYOUT_HEADER extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_HEADER
  }
  case object LAYOUT_FOOTER extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_FOOTER
  }
  case object LAYOUT_SECTION_HEADER extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_SECTION_HEADER
  }
  case object LAYOUT_PAGE_NUMBER extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_PAGE_NUMBER
  }
  case object LAYOUT_LIST extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_LIST
  }
  case object LAYOUT_FIGURE extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_FIGURE
  }
  case object LAYOUT_TABLE extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_TABLE
  }
  case object LAYOUT_KEY_VALUE extends zio.aws.textract.model.BlockType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.BlockType =
      software.amazon.awssdk.services.textract.model.BlockType.LAYOUT_KEY_VALUE
  }
}
