package zio.aws.textract.model
import zio.aws.textract.model.primitives.{
  AdapterVersionStatusMessage,
  DateTime,
  AdapterVersion,
  AdapterId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AdapterVersionOverview(
    adapterId: Optional[AdapterId] = Optional.Absent,
    adapterVersion: Optional[AdapterVersion] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    featureTypes: Optional[Iterable[zio.aws.textract.model.FeatureType]] =
      Optional.Absent,
    status: Optional[zio.aws.textract.model.AdapterVersionStatus] =
      Optional.Absent,
    statusMessage: Optional[AdapterVersionStatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.AdapterVersionOverview = {
    import AdapterVersionOverview.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.AdapterVersionOverview
      .builder()
      .optionallyWith(
        adapterId.map(value => AdapterId.unwrap(value): java.lang.String)
      )(_.adapterId)
      .optionallyWith(
        adapterVersion.map(value =>
          AdapterVersion.unwrap(value): java.lang.String
        )
      )(_.adapterVersion)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        featureTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.featureTypesWithStrings)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          AdapterVersionStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.AdapterVersionOverview.ReadOnly =
    zio.aws.textract.model.AdapterVersionOverview.wrap(buildAwsValue())
}
object AdapterVersionOverview {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.AdapterVersionOverview
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.AdapterVersionOverview =
      zio.aws.textract.model.AdapterVersionOverview(
        adapterId.map(value => value),
        adapterVersion.map(value => value),
        creationTime.map(value => value),
        featureTypes.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def adapterId: Optional[AdapterId]
    def adapterVersion: Optional[AdapterVersion]
    def creationTime: Optional[DateTime]
    def featureTypes: Optional[List[zio.aws.textract.model.FeatureType]]
    def status: Optional[zio.aws.textract.model.AdapterVersionStatus]
    def statusMessage: Optional[AdapterVersionStatusMessage]
    def getAdapterId: ZIO[Any, AwsError, AdapterId] =
      AwsError.unwrapOptionField("adapterId", adapterId)
    def getAdapterVersion: ZIO[Any, AwsError, AdapterVersion] =
      AwsError.unwrapOptionField("adapterVersion", adapterVersion)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFeatureTypes
        : ZIO[Any, AwsError, List[zio.aws.textract.model.FeatureType]] =
      AwsError.unwrapOptionField("featureTypes", featureTypes)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.textract.model.AdapterVersionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, AdapterVersionStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.AdapterVersionOverview
  ) extends zio.aws.textract.model.AdapterVersionOverview.ReadOnly {
    override val adapterId: Optional[AdapterId] = zio.aws.core.internal
      .optionalFromNullable(impl.adapterId())
      .map(value => zio.aws.textract.model.primitives.AdapterId(value))
    override val adapterVersion: Optional[AdapterVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adapterVersion())
        .map(value => zio.aws.textract.model.primitives.AdapterVersion(value))
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.textract.model.primitives.DateTime(value))
    override val featureTypes
        : Optional[List[zio.aws.textract.model.FeatureType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.FeatureType.wrap(item)
          }.toList
        )
    override val status: Optional[zio.aws.textract.model.AdapterVersionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.textract.model.AdapterVersionStatus.wrap(value))
    override val statusMessage: Optional[AdapterVersionStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.textract.model.primitives.AdapterVersionStatusMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.AdapterVersionOverview
  ): zio.aws.textract.model.AdapterVersionOverview.ReadOnly = new Wrapper(impl)
}
