package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.{
  AdapterVersion,
  AdapterPage,
  AdapterId
}
import scala.jdk.CollectionConverters.*
final case class Adapter(
    adapterId: AdapterId,
    pages: Optional[Iterable[AdapterPage]] = Optional.Absent,
    version: AdapterVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.Adapter = {
    import Adapter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.Adapter
      .builder()
      .adapterId(AdapterId.unwrap(adapterId): java.lang.String)
      .optionallyWith(
        pages.map(value =>
          value.map { item =>
            AdapterPage.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.pages)
      .version(AdapterVersion.unwrap(version): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.Adapter.ReadOnly =
    zio.aws.textract.model.Adapter.wrap(buildAwsValue())
}
object Adapter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.textract.model.Adapter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.Adapter = zio.aws.textract.model
      .Adapter(adapterId, pages.map(value => value), version)
    def adapterId: AdapterId
    def pages: Optional[List[AdapterPage]]
    def version: AdapterVersion
    def getAdapterId: ZIO[Any, Nothing, AdapterId] = ZIO.succeed(adapterId)
    def getPages: ZIO[Any, AwsError, List[AdapterPage]] =
      AwsError.unwrapOptionField("pages", pages)
    def getVersion: ZIO[Any, Nothing, AdapterVersion] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.Adapter
  ) extends zio.aws.textract.model.Adapter.ReadOnly {
    override val adapterId: AdapterId =
      zio.aws.textract.model.primitives.AdapterId(impl.adapterId())
    override val pages: Optional[List[AdapterPage]] = zio.aws.core.internal
      .optionalFromNullable(impl.pages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.primitives.AdapterPage(item)
        }.toList
      )
    override val version: AdapterVersion =
      zio.aws.textract.model.primitives.AdapterVersion(impl.version())
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.Adapter
  ): zio.aws.textract.model.Adapter.ReadOnly = new Wrapper(impl)
}
