package zio.aws.textract.model
import zio.aws.textract.model.primitives.{
  AdapterDescription,
  DateTime,
  AdapterName,
  AdapterId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateAdapterResponse(
    adapterId: Optional[AdapterId] = Optional.Absent,
    adapterName: Optional[AdapterName] = Optional.Absent,
    creationTime: Optional[DateTime] = Optional.Absent,
    description: Optional[AdapterDescription] = Optional.Absent,
    featureTypes: Optional[Iterable[zio.aws.textract.model.FeatureType]] =
      Optional.Absent,
    autoUpdate: Optional[zio.aws.textract.model.AutoUpdate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.UpdateAdapterResponse = {
    import UpdateAdapterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.UpdateAdapterResponse
      .builder()
      .optionallyWith(
        adapterId.map(value => AdapterId.unwrap(value): java.lang.String)
      )(_.adapterId)
      .optionallyWith(
        adapterName.map(value => AdapterName.unwrap(value): java.lang.String)
      )(_.adapterName)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        description.map(value =>
          AdapterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        featureTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.featureTypesWithStrings)
      .optionallyWith(autoUpdate.map(value => value.unwrap))(_.autoUpdate)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.UpdateAdapterResponse.ReadOnly =
    zio.aws.textract.model.UpdateAdapterResponse.wrap(buildAwsValue())
}
object UpdateAdapterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.UpdateAdapterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.UpdateAdapterResponse =
      zio.aws.textract.model.UpdateAdapterResponse(
        adapterId.map(value => value),
        adapterName.map(value => value),
        creationTime.map(value => value),
        description.map(value => value),
        featureTypes.map(value => value),
        autoUpdate.map(value => value)
      )
    def adapterId: Optional[AdapterId]
    def adapterName: Optional[AdapterName]
    def creationTime: Optional[DateTime]
    def description: Optional[AdapterDescription]
    def featureTypes: Optional[List[zio.aws.textract.model.FeatureType]]
    def autoUpdate: Optional[zio.aws.textract.model.AutoUpdate]
    def getAdapterId: ZIO[Any, AwsError, AdapterId] =
      AwsError.unwrapOptionField("adapterId", adapterId)
    def getAdapterName: ZIO[Any, AwsError, AdapterName] =
      AwsError.unwrapOptionField("adapterName", adapterName)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, AwsError, AdapterDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFeatureTypes
        : ZIO[Any, AwsError, List[zio.aws.textract.model.FeatureType]] =
      AwsError.unwrapOptionField("featureTypes", featureTypes)
    def getAutoUpdate: ZIO[Any, AwsError, zio.aws.textract.model.AutoUpdate] =
      AwsError.unwrapOptionField("autoUpdate", autoUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.UpdateAdapterResponse
  ) extends zio.aws.textract.model.UpdateAdapterResponse.ReadOnly {
    override val adapterId: Optional[AdapterId] = zio.aws.core.internal
      .optionalFromNullable(impl.adapterId())
      .map(value => zio.aws.textract.model.primitives.AdapterId(value))
    override val adapterName: Optional[AdapterName] = zio.aws.core.internal
      .optionalFromNullable(impl.adapterName())
      .map(value => zio.aws.textract.model.primitives.AdapterName(value))
    override val creationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.textract.model.primitives.DateTime(value))
    override val description: Optional[AdapterDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.textract.model.primitives.AdapterDescription(value)
        )
    override val featureTypes
        : Optional[List[zio.aws.textract.model.FeatureType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.FeatureType.wrap(item)
          }.toList
        )
    override val autoUpdate: Optional[zio.aws.textract.model.AutoUpdate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoUpdate())
        .map(value => zio.aws.textract.model.AutoUpdate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.UpdateAdapterResponse
  ): zio.aws.textract.model.UpdateAdapterResponse.ReadOnly = new Wrapper(impl)
}
