package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.{
  AdapterName,
  AdapterDescription,
  AdapterId
}
import scala.jdk.CollectionConverters.*
final case class UpdateAdapterRequest(
    adapterId: AdapterId,
    description: Optional[AdapterDescription] = Optional.Absent,
    adapterName: Optional[AdapterName] = Optional.Absent,
    autoUpdate: Optional[zio.aws.textract.model.AutoUpdate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.UpdateAdapterRequest = {
    import UpdateAdapterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.UpdateAdapterRequest
      .builder()
      .adapterId(AdapterId.unwrap(adapterId): java.lang.String)
      .optionallyWith(
        description.map(value =>
          AdapterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        adapterName.map(value => AdapterName.unwrap(value): java.lang.String)
      )(_.adapterName)
      .optionallyWith(autoUpdate.map(value => value.unwrap))(_.autoUpdate)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.UpdateAdapterRequest.ReadOnly =
    zio.aws.textract.model.UpdateAdapterRequest.wrap(buildAwsValue())
}
object UpdateAdapterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.UpdateAdapterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.UpdateAdapterRequest =
      zio.aws.textract.model.UpdateAdapterRequest(
        adapterId,
        description.map(value => value),
        adapterName.map(value => value),
        autoUpdate.map(value => value)
      )
    def adapterId: AdapterId
    def description: Optional[AdapterDescription]
    def adapterName: Optional[AdapterName]
    def autoUpdate: Optional[zio.aws.textract.model.AutoUpdate]
    def getAdapterId: ZIO[Any, Nothing, AdapterId] = ZIO.succeed(adapterId)
    def getDescription: ZIO[Any, AwsError, AdapterDescription] =
      AwsError.unwrapOptionField("description", description)
    def getAdapterName: ZIO[Any, AwsError, AdapterName] =
      AwsError.unwrapOptionField("adapterName", adapterName)
    def getAutoUpdate: ZIO[Any, AwsError, zio.aws.textract.model.AutoUpdate] =
      AwsError.unwrapOptionField("autoUpdate", autoUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.UpdateAdapterRequest
  ) extends zio.aws.textract.model.UpdateAdapterRequest.ReadOnly {
    override val adapterId: AdapterId =
      zio.aws.textract.model.primitives.AdapterId(impl.adapterId())
    override val description: Optional[AdapterDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.textract.model.primitives.AdapterDescription(value)
        )
    override val adapterName: Optional[AdapterName] = zio.aws.core.internal
      .optionalFromNullable(impl.adapterName())
      .map(value => zio.aws.textract.model.primitives.AdapterName(value))
    override val autoUpdate: Optional[zio.aws.textract.model.AutoUpdate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoUpdate())
        .map(value => zio.aws.textract.model.AutoUpdate.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.UpdateAdapterRequest
  ): zio.aws.textract.model.UpdateAdapterRequest.ReadOnly = new Wrapper(impl)
}
