package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListAdaptersResponse(
    adapters: Optional[Iterable[zio.aws.textract.model.AdapterOverview]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.ListAdaptersResponse = {
    import ListAdaptersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.ListAdaptersResponse
      .builder()
      .optionallyWith(
        adapters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.adapters)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.ListAdaptersResponse.ReadOnly =
    zio.aws.textract.model.ListAdaptersResponse.wrap(buildAwsValue())
}
object ListAdaptersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.ListAdaptersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.ListAdaptersResponse =
      zio.aws.textract.model.ListAdaptersResponse(
        adapters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def adapters
        : Optional[List[zio.aws.textract.model.AdapterOverview.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getAdapters: ZIO[Any, AwsError, List[
      zio.aws.textract.model.AdapterOverview.ReadOnly
    ]] = AwsError.unwrapOptionField("adapters", adapters)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.ListAdaptersResponse
  ) extends zio.aws.textract.model.ListAdaptersResponse.ReadOnly {
    override val adapters
        : Optional[List[zio.aws.textract.model.AdapterOverview.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adapters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.AdapterOverview.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.textract.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.ListAdaptersResponse
  ): zio.aws.textract.model.ListAdaptersResponse.ReadOnly = new Wrapper(impl)
}
