package zio.aws.textract.model
import zio.aws.textract.model.primitives.UInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class IdentityDocument(
    documentIndex: Optional[UInteger] = Optional.Absent,
    identityDocumentFields: Optional[
      Iterable[zio.aws.textract.model.IdentityDocumentField]
    ] = Optional.Absent,
    blocks: Optional[Iterable[zio.aws.textract.model.Block]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.IdentityDocument = {
    import IdentityDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.IdentityDocument
      .builder()
      .optionallyWith(
        documentIndex.map(value => UInteger.unwrap(value): Integer)
      )(_.documentIndex)
      .optionallyWith(
        identityDocumentFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.identityDocumentFields)
      .optionallyWith(
        blocks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blocks)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.IdentityDocument.ReadOnly =
    zio.aws.textract.model.IdentityDocument.wrap(buildAwsValue())
}
object IdentityDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.IdentityDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.IdentityDocument =
      zio.aws.textract.model.IdentityDocument(
        documentIndex.map(value => value),
        identityDocumentFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        blocks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def documentIndex: Optional[UInteger]
    def identityDocumentFields
        : Optional[List[zio.aws.textract.model.IdentityDocumentField.ReadOnly]]
    def blocks: Optional[List[zio.aws.textract.model.Block.ReadOnly]]
    def getDocumentIndex: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("documentIndex", documentIndex)
    def getIdentityDocumentFields: ZIO[Any, AwsError, List[
      zio.aws.textract.model.IdentityDocumentField.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "identityDocumentFields",
      identityDocumentFields
    )
    def getBlocks
        : ZIO[Any, AwsError, List[zio.aws.textract.model.Block.ReadOnly]] =
      AwsError.unwrapOptionField("blocks", blocks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.IdentityDocument
  ) extends zio.aws.textract.model.IdentityDocument.ReadOnly {
    override val documentIndex: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.documentIndex())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val identityDocumentFields: Optional[
      List[zio.aws.textract.model.IdentityDocumentField.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.identityDocumentFields())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.IdentityDocumentField.wrap(item)
        }.toList
      )
    override val blocks: Optional[List[zio.aws.textract.model.Block.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blocks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.Block.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.IdentityDocument
  ): zio.aws.textract.model.IdentityDocument.ReadOnly = new Wrapper(impl)
}
