package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Extraction(
    lendingDocument: Optional[zio.aws.textract.model.LendingDocument] =
      Optional.Absent,
    expenseDocument: Optional[zio.aws.textract.model.ExpenseDocument] =
      Optional.Absent,
    identityDocument: Optional[zio.aws.textract.model.IdentityDocument] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.Extraction = {
    import Extraction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.Extraction
      .builder()
      .optionallyWith(lendingDocument.map(value => value.buildAwsValue()))(
        _.lendingDocument
      )
      .optionallyWith(expenseDocument.map(value => value.buildAwsValue()))(
        _.expenseDocument
      )
      .optionallyWith(identityDocument.map(value => value.buildAwsValue()))(
        _.identityDocument
      )
      .build()
  }
  def asReadOnly: zio.aws.textract.model.Extraction.ReadOnly =
    zio.aws.textract.model.Extraction.wrap(buildAwsValue())
}
object Extraction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.Extraction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.Extraction =
      zio.aws.textract.model.Extraction(
        lendingDocument.map(value => value.asEditable),
        expenseDocument.map(value => value.asEditable),
        identityDocument.map(value => value.asEditable)
      )
    def lendingDocument
        : Optional[zio.aws.textract.model.LendingDocument.ReadOnly]
    def expenseDocument
        : Optional[zio.aws.textract.model.ExpenseDocument.ReadOnly]
    def identityDocument
        : Optional[zio.aws.textract.model.IdentityDocument.ReadOnly]
    def getLendingDocument
        : ZIO[Any, AwsError, zio.aws.textract.model.LendingDocument.ReadOnly] =
      AwsError.unwrapOptionField("lendingDocument", lendingDocument)
    def getExpenseDocument
        : ZIO[Any, AwsError, zio.aws.textract.model.ExpenseDocument.ReadOnly] =
      AwsError.unwrapOptionField("expenseDocument", expenseDocument)
    def getIdentityDocument
        : ZIO[Any, AwsError, zio.aws.textract.model.IdentityDocument.ReadOnly] =
      AwsError.unwrapOptionField("identityDocument", identityDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.Extraction
  ) extends zio.aws.textract.model.Extraction.ReadOnly {
    override val lendingDocument
        : Optional[zio.aws.textract.model.LendingDocument.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lendingDocument())
        .map(value => zio.aws.textract.model.LendingDocument.wrap(value))
    override val expenseDocument
        : Optional[zio.aws.textract.model.ExpenseDocument.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expenseDocument())
        .map(value => zio.aws.textract.model.ExpenseDocument.wrap(value))
    override val identityDocument
        : Optional[zio.aws.textract.model.IdentityDocument.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityDocument())
        .map(value => zio.aws.textract.model.IdentityDocument.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.Extraction
  ): zio.aws.textract.model.Extraction.ReadOnly = new Wrapper(impl)
}
