package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.textract.model.primitives.{AdapterVersion, AdapterId}
import scala.jdk.CollectionConverters.*
final case class DeleteAdapterVersionRequest(
    adapterId: AdapterId,
    adapterVersion: AdapterVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.DeleteAdapterVersionRequest = {
    import DeleteAdapterVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.DeleteAdapterVersionRequest
      .builder()
      .adapterId(AdapterId.unwrap(adapterId): java.lang.String)
      .adapterVersion(AdapterVersion.unwrap(adapterVersion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.DeleteAdapterVersionRequest.ReadOnly =
    zio.aws.textract.model.DeleteAdapterVersionRequest.wrap(buildAwsValue())
}
object DeleteAdapterVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.DeleteAdapterVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.DeleteAdapterVersionRequest =
      zio.aws.textract.model
        .DeleteAdapterVersionRequest(adapterId, adapterVersion)
    def adapterId: AdapterId
    def adapterVersion: AdapterVersion
    def getAdapterId: ZIO[Any, Nothing, AdapterId] = ZIO.succeed(adapterId)
    def getAdapterVersion: ZIO[Any, Nothing, AdapterVersion] =
      ZIO.succeed(adapterVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.DeleteAdapterVersionRequest
  ) extends zio.aws.textract.model.DeleteAdapterVersionRequest.ReadOnly {
    override val adapterId: AdapterId =
      zio.aws.textract.model.primitives.AdapterId(impl.adapterId())
    override val adapterVersion: AdapterVersion =
      zio.aws.textract.model.primitives.AdapterVersion(impl.adapterVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.DeleteAdapterVersionRequest
  ): zio.aws.textract.model.DeleteAdapterVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
