package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AdaptersConfig(
    adapters: Iterable[zio.aws.textract.model.Adapter]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.AdaptersConfig = {
    import AdaptersConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.AdaptersConfig
      .builder()
      .adapters(adapters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.AdaptersConfig.ReadOnly =
    zio.aws.textract.model.AdaptersConfig.wrap(buildAwsValue())
}
object AdaptersConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.AdaptersConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.AdaptersConfig =
      zio.aws.textract.model.AdaptersConfig(adapters.map { item =>
        item.asEditable
      })
    def adapters: List[zio.aws.textract.model.Adapter.ReadOnly]
    def getAdapters
        : ZIO[Any, Nothing, List[zio.aws.textract.model.Adapter.ReadOnly]] =
      ZIO.succeed(adapters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.AdaptersConfig
  ) extends zio.aws.textract.model.AdaptersConfig.ReadOnly {
    override val adapters: List[zio.aws.textract.model.Adapter.ReadOnly] = impl
      .adapters()
      .asScala
      .map { item =>
        zio.aws.textract.model.Adapter.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.AdaptersConfig
  ): zio.aws.textract.model.AdaptersConfig.ReadOnly = new Wrapper(impl)
}
