package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AdapterVersionDatasetConfig(
    manifestS3Object: Optional[zio.aws.textract.model.S3Object] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.AdapterVersionDatasetConfig = {
    import AdapterVersionDatasetConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.AdapterVersionDatasetConfig
      .builder()
      .optionallyWith(manifestS3Object.map(value => value.buildAwsValue()))(
        _.manifestS3Object
      )
      .build()
  }
  def asReadOnly: zio.aws.textract.model.AdapterVersionDatasetConfig.ReadOnly =
    zio.aws.textract.model.AdapterVersionDatasetConfig.wrap(buildAwsValue())
}
object AdapterVersionDatasetConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.AdapterVersionDatasetConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.AdapterVersionDatasetConfig =
      zio.aws.textract.model.AdapterVersionDatasetConfig(
        manifestS3Object.map(value => value.asEditable)
      )
    def manifestS3Object: Optional[zio.aws.textract.model.S3Object.ReadOnly]
    def getManifestS3Object
        : ZIO[Any, AwsError, zio.aws.textract.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("manifestS3Object", manifestS3Object)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.AdapterVersionDatasetConfig
  ) extends zio.aws.textract.model.AdapterVersionDatasetConfig.ReadOnly {
    override val manifestS3Object
        : Optional[zio.aws.textract.model.S3Object.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestS3Object())
        .map(value => zio.aws.textract.model.S3Object.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.AdapterVersionDatasetConfig
  ): zio.aws.textract.model.AdapterVersionDatasetConfig.ReadOnly = new Wrapper(
    impl
  )
}
