package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.{KMSKeyId, JobTag, ClientRequestToken}
import scala.jdk.CollectionConverters.*
final case class StartDocumentAnalysisRequest(
    documentLocation: zio.aws.textract.model.DocumentLocation,
    featureTypes: Iterable[zio.aws.textract.model.FeatureType],
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    jobTag: Optional[JobTag] = Optional.Absent,
    notificationChannel: Optional[zio.aws.textract.model.NotificationChannel] =
      Optional.Absent,
    outputConfig: Optional[zio.aws.textract.model.OutputConfig] =
      Optional.Absent,
    kmsKeyId: Optional[KMSKeyId] = Optional.Absent,
    queriesConfig: Optional[zio.aws.textract.model.QueriesConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest = {
    import StartDocumentAnalysisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest
      .builder()
      .documentLocation(documentLocation.buildAwsValue())
      .featureTypesWithStrings(featureTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .optionallyWith(notificationChannel.map(value => value.buildAwsValue()))(
        _.notificationChannel
      )
      .optionallyWith(outputConfig.map(value => value.buildAwsValue()))(
        _.outputConfig
      )
      .optionallyWith(
        kmsKeyId.map(value => KMSKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(queriesConfig.map(value => value.buildAwsValue()))(
        _.queriesConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.textract.model.StartDocumentAnalysisRequest.ReadOnly =
    zio.aws.textract.model.StartDocumentAnalysisRequest.wrap(buildAwsValue())
}
object StartDocumentAnalysisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.StartDocumentAnalysisRequest =
      zio.aws.textract.model.StartDocumentAnalysisRequest(
        documentLocation.asEditable,
        featureTypes,
        clientRequestToken.map(value => value),
        jobTag.map(value => value),
        notificationChannel.map(value => value.asEditable),
        outputConfig.map(value => value.asEditable),
        kmsKeyId.map(value => value),
        queriesConfig.map(value => value.asEditable)
      )
    def documentLocation: zio.aws.textract.model.DocumentLocation.ReadOnly
    def featureTypes: List[zio.aws.textract.model.FeatureType]
    def clientRequestToken: Optional[ClientRequestToken]
    def jobTag: Optional[JobTag]
    def notificationChannel
        : Optional[zio.aws.textract.model.NotificationChannel.ReadOnly]
    def outputConfig: Optional[zio.aws.textract.model.OutputConfig.ReadOnly]
    def kmsKeyId: Optional[KMSKeyId]
    def queriesConfig: Optional[zio.aws.textract.model.QueriesConfig.ReadOnly]
    def getDocumentLocation
        : ZIO[Any, Nothing, zio.aws.textract.model.DocumentLocation.ReadOnly] =
      ZIO.succeed(documentLocation)
    def getFeatureTypes
        : ZIO[Any, Nothing, List[zio.aws.textract.model.FeatureType]] =
      ZIO.succeed(featureTypes)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
    def getNotificationChannel: ZIO[
      Any,
      AwsError,
      zio.aws.textract.model.NotificationChannel.ReadOnly
    ] = AwsError.unwrapOptionField("notificationChannel", notificationChannel)
    def getOutputConfig
        : ZIO[Any, AwsError, zio.aws.textract.model.OutputConfig.ReadOnly] =
      AwsError.unwrapOptionField("outputConfig", outputConfig)
    def getKmsKeyId: ZIO[Any, AwsError, KMSKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getQueriesConfig
        : ZIO[Any, AwsError, zio.aws.textract.model.QueriesConfig.ReadOnly] =
      AwsError.unwrapOptionField("queriesConfig", queriesConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest
  ) extends zio.aws.textract.model.StartDocumentAnalysisRequest.ReadOnly {
    override val documentLocation
        : zio.aws.textract.model.DocumentLocation.ReadOnly =
      zio.aws.textract.model.DocumentLocation.wrap(impl.documentLocation())
    override val featureTypes: List[zio.aws.textract.model.FeatureType] = impl
      .featureTypes()
      .asScala
      .map { item =>
        zio.aws.textract.model.FeatureType.wrap(item)
      }
      .toList
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.textract.model.primitives.ClientRequestToken(value)
        )
    override val jobTag: Optional[JobTag] = zio.aws.core.internal
      .optionalFromNullable(impl.jobTag())
      .map(value => zio.aws.textract.model.primitives.JobTag(value))
    override val notificationChannel
        : Optional[zio.aws.textract.model.NotificationChannel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationChannel())
        .map(value => zio.aws.textract.model.NotificationChannel.wrap(value))
    override val outputConfig
        : Optional[zio.aws.textract.model.OutputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputConfig())
        .map(value => zio.aws.textract.model.OutputConfig.wrap(value))
    override val kmsKeyId: Optional[KMSKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.textract.model.primitives.KMSKeyId(value))
    override val queriesConfig
        : Optional[zio.aws.textract.model.QueriesConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queriesConfig())
        .map(value => zio.aws.textract.model.QueriesConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest
  ): zio.aws.textract.model.StartDocumentAnalysisRequest.ReadOnly = new Wrapper(
    impl
  )
}
