package zio.aws.textract.model
import zio.aws.textract.model.primitives.UInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DetectedSignature(page: Optional[UInteger] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.DetectedSignature = {
    import DetectedSignature.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.DetectedSignature
      .builder()
      .optionallyWith(page.map(value => UInteger.unwrap(value): Integer))(
        _.page
      )
      .build()
  }
  def asReadOnly: zio.aws.textract.model.DetectedSignature.ReadOnly =
    zio.aws.textract.model.DetectedSignature.wrap(buildAwsValue())
}
object DetectedSignature {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.DetectedSignature
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.DetectedSignature =
      zio.aws.textract.model.DetectedSignature(page.map(value => value))
    def page: Optional[UInteger]
    def getPage: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("page", page)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.DetectedSignature
  ) extends zio.aws.textract.model.DetectedSignature.ReadOnly {
    override val page: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.page())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.DetectedSignature
  ): zio.aws.textract.model.DetectedSignature.ReadOnly = new Wrapper(impl)
}
