package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LendingDocument(
    lendingFields: Optional[Iterable[zio.aws.textract.model.LendingField]] =
      Optional.Absent,
    signatureDetections: Optional[
      Iterable[zio.aws.textract.model.SignatureDetection]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.LendingDocument = {
    import LendingDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.LendingDocument
      .builder()
      .optionallyWith(
        lendingFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lendingFields)
      .optionallyWith(
        signatureDetections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.signatureDetections)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.LendingDocument.ReadOnly =
    zio.aws.textract.model.LendingDocument.wrap(buildAwsValue())
}
object LendingDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.LendingDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.LendingDocument =
      zio.aws.textract.model.LendingDocument(
        lendingFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        signatureDetections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def lendingFields
        : Optional[List[zio.aws.textract.model.LendingField.ReadOnly]]
    def signatureDetections
        : Optional[List[zio.aws.textract.model.SignatureDetection.ReadOnly]]
    def getLendingFields: ZIO[Any, AwsError, List[
      zio.aws.textract.model.LendingField.ReadOnly
    ]] = AwsError.unwrapOptionField("lendingFields", lendingFields)
    def getSignatureDetections: ZIO[Any, AwsError, List[
      zio.aws.textract.model.SignatureDetection.ReadOnly
    ]] = AwsError.unwrapOptionField("signatureDetections", signatureDetections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.LendingDocument
  ) extends zio.aws.textract.model.LendingDocument.ReadOnly {
    override val lendingFields
        : Optional[List[zio.aws.textract.model.LendingField.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lendingFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.LendingField.wrap(item)
          }.toList
        )
    override val signatureDetections
        : Optional[List[zio.aws.textract.model.SignatureDetection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signatureDetections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.SignatureDetection.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.LendingDocument
  ): zio.aws.textract.model.LendingDocument.ReadOnly = new Wrapper(impl)
}
