package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class Relationship(
    `type`: Optional[zio.aws.textract.model.RelationshipType] = Optional.Absent,
    ids: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.Relationship = {
    import Relationship.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.Relationship
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.Relationship.ReadOnly =
    zio.aws.textract.model.Relationship.wrap(buildAwsValue())
}
object Relationship {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.Relationship
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.Relationship = zio.aws.textract.model
      .Relationship(`type`.map(value => value), ids.map(value => value))
    def `type`: Optional[zio.aws.textract.model.RelationshipType]
    def ids: Optional[List[NonEmptyString]]
    def getType: ZIO[Any, AwsError, zio.aws.textract.model.RelationshipType] =
      AwsError.unwrapOptionField("type", `type`)
    def getIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("ids", ids)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.Relationship
  ) extends zio.aws.textract.model.Relationship.ReadOnly {
    override val `type`: Optional[zio.aws.textract.model.RelationshipType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.textract.model.RelationshipType.wrap(value))
    override val ids: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.Relationship
  ): zio.aws.textract.model.Relationship.ReadOnly = new Wrapper(impl)
}
