package zio.aws.textract.model
import zio.aws.textract.model.primitives.UInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UndetectedSignature(
    page: Optional[UInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.UndetectedSignature = {
    import UndetectedSignature.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.UndetectedSignature
      .builder()
      .optionallyWith(page.map(value => UInteger.unwrap(value): Integer))(
        _.page
      )
      .build()
  }
  def asReadOnly: zio.aws.textract.model.UndetectedSignature.ReadOnly =
    zio.aws.textract.model.UndetectedSignature.wrap(buildAwsValue())
}
object UndetectedSignature {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.UndetectedSignature
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.UndetectedSignature =
      zio.aws.textract.model.UndetectedSignature(page.map(value => value))
    def page: Optional[UInteger]
    def getPage: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("page", page)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.UndetectedSignature
  ) extends zio.aws.textract.model.UndetectedSignature.ReadOnly {
    override val page: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.page())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.UndetectedSignature
  ): zio.aws.textract.model.UndetectedSignature.ReadOnly = new Wrapper(impl)
}
