package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DocumentLocation(
    s3Object: Optional[zio.aws.textract.model.S3Object] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.DocumentLocation = {
    import DocumentLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.DocumentLocation
      .builder()
      .optionallyWith(s3Object.map(value => value.buildAwsValue()))(_.s3Object)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.DocumentLocation.ReadOnly =
    zio.aws.textract.model.DocumentLocation.wrap(buildAwsValue())
}
object DocumentLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.DocumentLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.DocumentLocation =
      zio.aws.textract.model
        .DocumentLocation(s3Object.map(value => value.asEditable))
    def s3Object: Optional[zio.aws.textract.model.S3Object.ReadOnly]
    def getS3Object
        : ZIO[Any, AwsError, zio.aws.textract.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("s3Object", s3Object)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.DocumentLocation
  ) extends zio.aws.textract.model.DocumentLocation.ReadOnly {
    override val s3Object: Optional[zio.aws.textract.model.S3Object.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Object())
        .map(value => zio.aws.textract.model.S3Object.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.DocumentLocation
  ): zio.aws.textract.model.DocumentLocation.ReadOnly = new Wrapper(impl)
}
