package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.{
  S3ObjectVersion,
  S3ObjectName,
  S3Bucket
}
import scala.jdk.CollectionConverters.*
final case class S3Object(
    bucket: Optional[S3Bucket] = Optional.Absent,
    name: Optional[S3ObjectName] = Optional.Absent,
    version: Optional[S3ObjectVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.S3Object = {
    import S3Object.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.S3Object
      .builder()
      .optionallyWith(
        bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        name.map(value => S3ObjectName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => S3ObjectVersion.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.S3Object.ReadOnly =
    zio.aws.textract.model.S3Object.wrap(buildAwsValue())
}
object S3Object {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.textract.model.S3Object] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.S3Object =
      zio.aws.textract.model.S3Object(
        bucket.map(value => value),
        name.map(value => value),
        version.map(value => value)
      )
    def bucket: Optional[S3Bucket]
    def name: Optional[S3ObjectName]
    def version: Optional[S3ObjectVersion]
    def getBucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getName: ZIO[Any, AwsError, S3ObjectName] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, S3ObjectVersion] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.S3Object
  ) extends zio.aws.textract.model.S3Object.ReadOnly {
    override val bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.textract.model.primitives.S3Bucket(value))
    override val name: Optional[S3ObjectName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.textract.model.primitives.S3ObjectName(value))
    override val version: Optional[S3ObjectVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.textract.model.primitives.S3ObjectVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.S3Object
  ): zio.aws.textract.model.S3Object.ReadOnly = new Wrapper(impl)
}
