package zio.aws.textract.model
import zio.aws.textract.model.primitives.{NonEmptyString, UInteger, Percent}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Block(
    blockType: Optional[zio.aws.textract.model.BlockType] = Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent,
    text: Optional[String] = Optional.Absent,
    textType: Optional[zio.aws.textract.model.TextType] = Optional.Absent,
    rowIndex: Optional[UInteger] = Optional.Absent,
    columnIndex: Optional[UInteger] = Optional.Absent,
    rowSpan: Optional[UInteger] = Optional.Absent,
    columnSpan: Optional[UInteger] = Optional.Absent,
    geometry: Optional[zio.aws.textract.model.Geometry] = Optional.Absent,
    id: Optional[NonEmptyString] = Optional.Absent,
    relationships: Optional[Iterable[zio.aws.textract.model.Relationship]] =
      Optional.Absent,
    entityTypes: Optional[Iterable[zio.aws.textract.model.EntityType]] =
      Optional.Absent,
    selectionStatus: Optional[zio.aws.textract.model.SelectionStatus] =
      Optional.Absent,
    page: Optional[UInteger] = Optional.Absent,
    query: Optional[zio.aws.textract.model.Query] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.textract.model.Block = {
    import Block.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.Block
      .builder()
      .optionallyWith(blockType.map(value => value.unwrap))(_.blockType)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(textType.map(value => value.unwrap))(_.textType)
      .optionallyWith(rowIndex.map(value => UInteger.unwrap(value): Integer))(
        _.rowIndex
      )
      .optionallyWith(
        columnIndex.map(value => UInteger.unwrap(value): Integer)
      )(_.columnIndex)
      .optionallyWith(rowSpan.map(value => UInteger.unwrap(value): Integer))(
        _.rowSpan
      )
      .optionallyWith(columnSpan.map(value => UInteger.unwrap(value): Integer))(
        _.columnSpan
      )
      .optionallyWith(geometry.map(value => value.buildAwsValue()))(_.geometry)
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        relationships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relationships)
      .optionallyWith(
        entityTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.entityTypesWithStrings)
      .optionallyWith(selectionStatus.map(value => value.unwrap))(
        _.selectionStatus
      )
      .optionallyWith(page.map(value => UInteger.unwrap(value): Integer))(
        _.page
      )
      .optionallyWith(query.map(value => value.buildAwsValue()))(_.query)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.Block.ReadOnly =
    zio.aws.textract.model.Block.wrap(buildAwsValue())
}
object Block {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.textract.model.Block] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.Block = zio.aws.textract.model.Block(
      blockType.map(value => value),
      confidence.map(value => value),
      text.map(value => value),
      textType.map(value => value),
      rowIndex.map(value => value),
      columnIndex.map(value => value),
      rowSpan.map(value => value),
      columnSpan.map(value => value),
      geometry.map(value => value.asEditable),
      id.map(value => value),
      relationships.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      entityTypes.map(value => value),
      selectionStatus.map(value => value),
      page.map(value => value),
      query.map(value => value.asEditable)
    )
    def blockType: Optional[zio.aws.textract.model.BlockType]
    def confidence: Optional[Percent]
    def text: Optional[String]
    def textType: Optional[zio.aws.textract.model.TextType]
    def rowIndex: Optional[UInteger]
    def columnIndex: Optional[UInteger]
    def rowSpan: Optional[UInteger]
    def columnSpan: Optional[UInteger]
    def geometry: Optional[zio.aws.textract.model.Geometry.ReadOnly]
    def id: Optional[NonEmptyString]
    def relationships
        : Optional[List[zio.aws.textract.model.Relationship.ReadOnly]]
    def entityTypes: Optional[List[zio.aws.textract.model.EntityType]]
    def selectionStatus: Optional[zio.aws.textract.model.SelectionStatus]
    def page: Optional[UInteger]
    def query: Optional[zio.aws.textract.model.Query.ReadOnly]
    def getBlockType: ZIO[Any, AwsError, zio.aws.textract.model.BlockType] =
      AwsError.unwrapOptionField("blockType", blockType)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getTextType: ZIO[Any, AwsError, zio.aws.textract.model.TextType] =
      AwsError.unwrapOptionField("textType", textType)
    def getRowIndex: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("rowIndex", rowIndex)
    def getColumnIndex: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("columnIndex", columnIndex)
    def getRowSpan: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("rowSpan", rowSpan)
    def getColumnSpan: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("columnSpan", columnSpan)
    def getGeometry
        : ZIO[Any, AwsError, zio.aws.textract.model.Geometry.ReadOnly] =
      AwsError.unwrapOptionField("geometry", geometry)
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getRelationships: ZIO[Any, AwsError, List[
      zio.aws.textract.model.Relationship.ReadOnly
    ]] = AwsError.unwrapOptionField("relationships", relationships)
    def getEntityTypes
        : ZIO[Any, AwsError, List[zio.aws.textract.model.EntityType]] =
      AwsError.unwrapOptionField("entityTypes", entityTypes)
    def getSelectionStatus
        : ZIO[Any, AwsError, zio.aws.textract.model.SelectionStatus] =
      AwsError.unwrapOptionField("selectionStatus", selectionStatus)
    def getPage: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("page", page)
    def getQuery: ZIO[Any, AwsError, zio.aws.textract.model.Query.ReadOnly] =
      AwsError.unwrapOptionField("query", query)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.Block
  ) extends zio.aws.textract.model.Block.ReadOnly {
    override val blockType: Optional[zio.aws.textract.model.BlockType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockType())
        .map(value => zio.aws.textract.model.BlockType.wrap(value))
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.textract.model.primitives.Percent(value))
    override val text: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => value: String)
    override val textType: Optional[zio.aws.textract.model.TextType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textType())
        .map(value => zio.aws.textract.model.TextType.wrap(value))
    override val rowIndex: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.rowIndex())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val columnIndex: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.columnIndex())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val rowSpan: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.rowSpan())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val columnSpan: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.columnSpan())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val geometry: Optional[zio.aws.textract.model.Geometry.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geometry())
        .map(value => zio.aws.textract.model.Geometry.wrap(value))
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.textract.model.primitives.NonEmptyString(value))
    override val relationships
        : Optional[List[zio.aws.textract.model.Relationship.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relationships())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.Relationship.wrap(item)
          }.toList
        )
    override val entityTypes
        : Optional[List[zio.aws.textract.model.EntityType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entityTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.EntityType.wrap(item)
          }.toList
        )
    override val selectionStatus
        : Optional[zio.aws.textract.model.SelectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selectionStatus())
        .map(value => zio.aws.textract.model.SelectionStatus.wrap(value))
    override val page: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.page())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val query: Optional[zio.aws.textract.model.Query.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.query())
        .map(value => zio.aws.textract.model.Query.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.Block
  ): zio.aws.textract.model.Block.ReadOnly = new Wrapper(impl)
}
