package zio.aws.textract.model
import zio.aws.textract.model.primitives.{UInteger, ErrorCode}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Warning(
    errorCode: Optional[ErrorCode] = Optional.Absent,
    pages: Optional[Iterable[UInteger]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.Warning = {
    import Warning.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.Warning
      .builder()
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        pages.map(value =>
          value.map { item =>
            UInteger.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.pages)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.Warning.ReadOnly =
    zio.aws.textract.model.Warning.wrap(buildAwsValue())
}
object Warning {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.textract.model.Warning] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.Warning = zio.aws.textract.model
      .Warning(errorCode.map(value => value), pages.map(value => value))
    def errorCode: Optional[ErrorCode]
    def pages: Optional[List[UInteger]]
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getPages: ZIO[Any, AwsError, List[UInteger]] =
      AwsError.unwrapOptionField("pages", pages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.Warning
  ) extends zio.aws.textract.model.Warning.ReadOnly {
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.textract.model.primitives.ErrorCode(value))
    override val pages: Optional[List[UInteger]] = zio.aws.core.internal
      .optionalFromNullable(impl.pages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.primitives.UInteger(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.Warning
  ): zio.aws.textract.model.Warning.ReadOnly = new Wrapper(impl)
}
