package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.Percent
import scala.jdk.CollectionConverters.*
final case class ExpenseCurrency(
    code: Optional[String] = Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.ExpenseCurrency = {
    import ExpenseCurrency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.ExpenseCurrency
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.ExpenseCurrency.ReadOnly =
    zio.aws.textract.model.ExpenseCurrency.wrap(buildAwsValue())
}
object ExpenseCurrency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.ExpenseCurrency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.ExpenseCurrency =
      zio.aws.textract.model.ExpenseCurrency(
        code.map(value => value),
        confidence.map(value => value)
      )
    def code: Optional[String]
    def confidence: Optional[Percent]
    def getCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("code", code)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.ExpenseCurrency
  ) extends zio.aws.textract.model.ExpenseCurrency.ReadOnly {
    override val code: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => value: String)
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.textract.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.ExpenseCurrency
  ): zio.aws.textract.model.ExpenseCurrency.ReadOnly = new Wrapper(impl)
}
