package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.textract.model.primitives.JobId
import scala.jdk.CollectionConverters.*
final case class GetLendingAnalysisSummaryRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryRequest = {
    import GetLendingAnalysisSummaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.textract.model.GetLendingAnalysisSummaryRequest.ReadOnly =
    zio.aws.textract.model.GetLendingAnalysisSummaryRequest
      .wrap(buildAwsValue())
}
object GetLendingAnalysisSummaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.GetLendingAnalysisSummaryRequest =
      zio.aws.textract.model.GetLendingAnalysisSummaryRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryRequest
  ) extends zio.aws.textract.model.GetLendingAnalysisSummaryRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.textract.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryRequest
  ): zio.aws.textract.model.GetLendingAnalysisSummaryRequest.ReadOnly =
    new Wrapper(impl)
}
