package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class QueriesConfig(
    queries: Iterable[zio.aws.textract.model.Query]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.QueriesConfig = {
    import QueriesConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.QueriesConfig
      .builder()
      .queries(queries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.QueriesConfig.ReadOnly =
    zio.aws.textract.model.QueriesConfig.wrap(buildAwsValue())
}
object QueriesConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.QueriesConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.QueriesConfig =
      zio.aws.textract.model.QueriesConfig(queries.map { item =>
        item.asEditable
      })
    def queries: List[zio.aws.textract.model.Query.ReadOnly]
    def getQueries
        : ZIO[Any, Nothing, List[zio.aws.textract.model.Query.ReadOnly]] =
      ZIO.succeed(queries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.QueriesConfig
  ) extends zio.aws.textract.model.QueriesConfig.ReadOnly {
    override val queries: List[zio.aws.textract.model.Query.ReadOnly] = impl
      .queries()
      .asScala
      .map { item =>
        zio.aws.textract.model.Query.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.QueriesConfig
  ): zio.aws.textract.model.QueriesConfig.ReadOnly = new Wrapper(impl)
}
