package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AnalyzeDocumentRequest(
    document: zio.aws.textract.model.Document,
    featureTypes: Iterable[zio.aws.textract.model.FeatureType],
    humanLoopConfig: Optional[zio.aws.textract.model.HumanLoopConfig] =
      Optional.Absent,
    queriesConfig: Optional[zio.aws.textract.model.QueriesConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.AnalyzeDocumentRequest = {
    import AnalyzeDocumentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.AnalyzeDocumentRequest
      .builder()
      .document(document.buildAwsValue())
      .featureTypesWithStrings(featureTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(humanLoopConfig.map(value => value.buildAwsValue()))(
        _.humanLoopConfig
      )
      .optionallyWith(queriesConfig.map(value => value.buildAwsValue()))(
        _.queriesConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.textract.model.AnalyzeDocumentRequest.ReadOnly =
    zio.aws.textract.model.AnalyzeDocumentRequest.wrap(buildAwsValue())
}
object AnalyzeDocumentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.AnalyzeDocumentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.AnalyzeDocumentRequest =
      zio.aws.textract.model.AnalyzeDocumentRequest(
        document.asEditable,
        featureTypes,
        humanLoopConfig.map(value => value.asEditable),
        queriesConfig.map(value => value.asEditable)
      )
    def document: zio.aws.textract.model.Document.ReadOnly
    def featureTypes: List[zio.aws.textract.model.FeatureType]
    def humanLoopConfig
        : Optional[zio.aws.textract.model.HumanLoopConfig.ReadOnly]
    def queriesConfig: Optional[zio.aws.textract.model.QueriesConfig.ReadOnly]
    def getDocument
        : ZIO[Any, Nothing, zio.aws.textract.model.Document.ReadOnly] =
      ZIO.succeed(document)
    def getFeatureTypes
        : ZIO[Any, Nothing, List[zio.aws.textract.model.FeatureType]] =
      ZIO.succeed(featureTypes)
    def getHumanLoopConfig
        : ZIO[Any, AwsError, zio.aws.textract.model.HumanLoopConfig.ReadOnly] =
      AwsError.unwrapOptionField("humanLoopConfig", humanLoopConfig)
    def getQueriesConfig
        : ZIO[Any, AwsError, zio.aws.textract.model.QueriesConfig.ReadOnly] =
      AwsError.unwrapOptionField("queriesConfig", queriesConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeDocumentRequest
  ) extends zio.aws.textract.model.AnalyzeDocumentRequest.ReadOnly {
    override val document: zio.aws.textract.model.Document.ReadOnly =
      zio.aws.textract.model.Document.wrap(impl.document())
    override val featureTypes: List[zio.aws.textract.model.FeatureType] = impl
      .featureTypes()
      .asScala
      .map { item =>
        zio.aws.textract.model.FeatureType.wrap(item)
      }
      .toList
    override val humanLoopConfig
        : Optional[zio.aws.textract.model.HumanLoopConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.humanLoopConfig())
        .map(value => zio.aws.textract.model.HumanLoopConfig.wrap(value))
    override val queriesConfig
        : Optional[zio.aws.textract.model.QueriesConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queriesConfig())
        .map(value => zio.aws.textract.model.QueriesConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeDocumentRequest
  ): zio.aws.textract.model.AnalyzeDocumentRequest.ReadOnly = new Wrapper(impl)
}
