package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.Percent
import scala.jdk.CollectionConverters.*
final case class AnalyzeIDDetections(
    text: String,
    normalizedValue: Optional[zio.aws.textract.model.NormalizedValue] =
      Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.AnalyzeIDDetections = {
    import AnalyzeIDDetections.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.AnalyzeIDDetections
      .builder()
      .text(text: java.lang.String)
      .optionallyWith(normalizedValue.map(value => value.buildAwsValue()))(
        _.normalizedValue
      )
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.AnalyzeIDDetections.ReadOnly =
    zio.aws.textract.model.AnalyzeIDDetections.wrap(buildAwsValue())
}
object AnalyzeIDDetections {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.AnalyzeIDDetections
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.AnalyzeIDDetections =
      zio.aws.textract.model.AnalyzeIDDetections(
        text,
        normalizedValue.map(value => value.asEditable),
        confidence.map(value => value)
      )
    def text: String
    def normalizedValue
        : Optional[zio.aws.textract.model.NormalizedValue.ReadOnly]
    def confidence: Optional[Percent]
    def getText: ZIO[Any, Nothing, String] = ZIO.succeed(text)
    def getNormalizedValue
        : ZIO[Any, AwsError, zio.aws.textract.model.NormalizedValue.ReadOnly] =
      AwsError.unwrapOptionField("normalizedValue", normalizedValue)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeIDDetections
  ) extends zio.aws.textract.model.AnalyzeIDDetections.ReadOnly {
    override val text: String = impl.text(): String
    override val normalizedValue
        : Optional[zio.aws.textract.model.NormalizedValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.normalizedValue())
        .map(value => zio.aws.textract.model.NormalizedValue.wrap(value))
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.textract.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeIDDetections
  ): zio.aws.textract.model.AnalyzeIDDetections.ReadOnly = new Wrapper(impl)
}
