package zio.aws.textract.model
import scala.jdk.CollectionConverters.*
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.textract.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.textract.model.JobStatus
  ): zio.aws.textract.model.JobStatus = value match {
    case software.amazon.awssdk.services.textract.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.textract.model.JobStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.textract.model.JobStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.textract.model.JobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.textract.model.JobStatus.PARTIAL_SUCCESS =>
      val r = PARTIAL_SUCCESS
      r
  }
  case object unknownToSdkVersion extends zio.aws.textract.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.JobStatus =
      software.amazon.awssdk.services.textract.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.textract.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.JobStatus =
      software.amazon.awssdk.services.textract.model.JobStatus.IN_PROGRESS
  }
  case object SUCCEEDED extends zio.aws.textract.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.JobStatus =
      software.amazon.awssdk.services.textract.model.JobStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.textract.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.JobStatus =
      software.amazon.awssdk.services.textract.model.JobStatus.FAILED
  }
  case object PARTIAL_SUCCESS extends zio.aws.textract.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.JobStatus =
      software.amazon.awssdk.services.textract.model.JobStatus.PARTIAL_SUCCESS
  }
}
