package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.{StatusMessage, PaginationToken}
import scala.jdk.CollectionConverters.*
final case class GetExpenseAnalysisResponse(
    documentMetadata: Optional[zio.aws.textract.model.DocumentMetadata] =
      Optional.Absent,
    jobStatus: Optional[zio.aws.textract.model.JobStatus] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    expenseDocuments: Optional[
      Iterable[zio.aws.textract.model.ExpenseDocument]
    ] = Optional.Absent,
    warnings: Optional[Iterable[zio.aws.textract.model.Warning]] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    analyzeExpenseModelVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.GetExpenseAnalysisResponse = {
    import GetExpenseAnalysisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.GetExpenseAnalysisResponse
      .builder()
      .optionallyWith(documentMetadata.map(value => value.buildAwsValue()))(
        _.documentMetadata
      )
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        expenseDocuments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.expenseDocuments)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.warnings)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        analyzeExpenseModelVersion.map(value => value: java.lang.String)
      )(_.analyzeExpenseModelVersion)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly =
    zio.aws.textract.model.GetExpenseAnalysisResponse.wrap(buildAwsValue())
}
object GetExpenseAnalysisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.GetExpenseAnalysisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.GetExpenseAnalysisResponse =
      zio.aws.textract.model.GetExpenseAnalysisResponse(
        documentMetadata.map(value => value.asEditable),
        jobStatus.map(value => value),
        nextToken.map(value => value),
        expenseDocuments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        warnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statusMessage.map(value => value),
        analyzeExpenseModelVersion.map(value => value)
      )
    def documentMetadata
        : Optional[zio.aws.textract.model.DocumentMetadata.ReadOnly]
    def jobStatus: Optional[zio.aws.textract.model.JobStatus]
    def nextToken: Optional[PaginationToken]
    def expenseDocuments
        : Optional[List[zio.aws.textract.model.ExpenseDocument.ReadOnly]]
    def warnings: Optional[List[zio.aws.textract.model.Warning.ReadOnly]]
    def statusMessage: Optional[StatusMessage]
    def analyzeExpenseModelVersion: Optional[String]
    def getDocumentMetadata
        : ZIO[Any, AwsError, zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("documentMetadata", documentMetadata)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.textract.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getExpenseDocuments: ZIO[Any, AwsError, List[
      zio.aws.textract.model.ExpenseDocument.ReadOnly
    ]] = AwsError.unwrapOptionField("expenseDocuments", expenseDocuments)
    def getWarnings
        : ZIO[Any, AwsError, List[zio.aws.textract.model.Warning.ReadOnly]] =
      AwsError.unwrapOptionField("warnings", warnings)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getAnalyzeExpenseModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "analyzeExpenseModelVersion",
        analyzeExpenseModelVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.GetExpenseAnalysisResponse
  ) extends zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly {
    override val documentMetadata
        : Optional[zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentMetadata())
        .map(value => zio.aws.textract.model.DocumentMetadata.wrap(value))
    override val jobStatus: Optional[zio.aws.textract.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.textract.model.JobStatus.wrap(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.textract.model.primitives.PaginationToken(value))
    override val expenseDocuments
        : Optional[List[zio.aws.textract.model.ExpenseDocument.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expenseDocuments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.ExpenseDocument.wrap(item)
          }.toList
        )
    override val warnings
        : Optional[List[zio.aws.textract.model.Warning.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.warnings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.Warning.wrap(item)
          }.toList
        )
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.textract.model.primitives.StatusMessage(value))
    override val analyzeExpenseModelVersion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analyzeExpenseModelVersion())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.GetExpenseAnalysisResponse
  ): zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly = new Wrapper(
    impl
  )
}
