package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DetectDocumentTextRequest(
    document: zio.aws.textract.model.Document
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.DetectDocumentTextRequest = {
    import DetectDocumentTextRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.DetectDocumentTextRequest
      .builder()
      .document(document.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.textract.model.DetectDocumentTextRequest.ReadOnly =
    zio.aws.textract.model.DetectDocumentTextRequest.wrap(buildAwsValue())
}
object DetectDocumentTextRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.DetectDocumentTextRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.DetectDocumentTextRequest =
      zio.aws.textract.model.DetectDocumentTextRequest(document.asEditable)
    def document: zio.aws.textract.model.Document.ReadOnly
    def getDocument
        : ZIO[Any, Nothing, zio.aws.textract.model.Document.ReadOnly] =
      ZIO.succeed(document)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.DetectDocumentTextRequest
  ) extends zio.aws.textract.model.DetectDocumentTextRequest.ReadOnly {
    override val document: zio.aws.textract.model.Document.ReadOnly =
      zio.aws.textract.model.Document.wrap(impl.document())
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.DetectDocumentTextRequest
  ): zio.aws.textract.model.DetectDocumentTextRequest.ReadOnly = new Wrapper(
    impl
  )
}
