package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.{
  HumanLoopActivationConditionsEvaluationResults,
  HumanLoopActivationReason,
  HumanLoopArn
}
import scala.jdk.CollectionConverters.*
final case class HumanLoopActivationOutput(
    humanLoopArn: Optional[HumanLoopArn] = Optional.Absent,
    humanLoopActivationReasons: Optional[Iterable[HumanLoopActivationReason]] =
      Optional.Absent,
    humanLoopActivationConditionsEvaluationResults: Optional[
      HumanLoopActivationConditionsEvaluationResults
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.HumanLoopActivationOutput = {
    import HumanLoopActivationOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.HumanLoopActivationOutput
      .builder()
      .optionallyWith(
        humanLoopArn.map(value => HumanLoopArn.unwrap(value): java.lang.String)
      )(_.humanLoopArn)
      .optionallyWith(
        humanLoopActivationReasons.map(value =>
          value.map { item =>
            HumanLoopActivationReason.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.humanLoopActivationReasons)
      .optionallyWith(
        humanLoopActivationConditionsEvaluationResults.map(value =>
          HumanLoopActivationConditionsEvaluationResults.unwrap(
            value
          ): java.lang.String
        )
      )(_.humanLoopActivationConditionsEvaluationResults)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.HumanLoopActivationOutput.ReadOnly =
    zio.aws.textract.model.HumanLoopActivationOutput.wrap(buildAwsValue())
}
object HumanLoopActivationOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.HumanLoopActivationOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.HumanLoopActivationOutput =
      zio.aws.textract.model.HumanLoopActivationOutput(
        humanLoopArn.map(value => value),
        humanLoopActivationReasons.map(value => value),
        humanLoopActivationConditionsEvaluationResults.map(value => value)
      )
    def humanLoopArn: Optional[HumanLoopArn]
    def humanLoopActivationReasons: Optional[List[HumanLoopActivationReason]]
    def humanLoopActivationConditionsEvaluationResults
        : Optional[HumanLoopActivationConditionsEvaluationResults]
    def getHumanLoopArn: ZIO[Any, AwsError, HumanLoopArn] =
      AwsError.unwrapOptionField("humanLoopArn", humanLoopArn)
    def getHumanLoopActivationReasons
        : ZIO[Any, AwsError, List[HumanLoopActivationReason]] =
      AwsError.unwrapOptionField(
        "humanLoopActivationReasons",
        humanLoopActivationReasons
      )
    def getHumanLoopActivationConditionsEvaluationResults
        : ZIO[Any, AwsError, HumanLoopActivationConditionsEvaluationResults] =
      AwsError.unwrapOptionField(
        "humanLoopActivationConditionsEvaluationResults",
        humanLoopActivationConditionsEvaluationResults
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.HumanLoopActivationOutput
  ) extends zio.aws.textract.model.HumanLoopActivationOutput.ReadOnly {
    override val humanLoopArn: Optional[HumanLoopArn] = zio.aws.core.internal
      .optionalFromNullable(impl.humanLoopArn())
      .map(value => zio.aws.textract.model.primitives.HumanLoopArn(value))
    override val humanLoopActivationReasons
        : Optional[List[HumanLoopActivationReason]] = zio.aws.core.internal
      .optionalFromNullable(impl.humanLoopActivationReasons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.primitives.HumanLoopActivationReason(item)
        }.toList
      )
    override val humanLoopActivationConditionsEvaluationResults
        : Optional[HumanLoopActivationConditionsEvaluationResults] =
      zio.aws.core.internal
        .optionalFromNullable(
          impl.humanLoopActivationConditionsEvaluationResults()
        )
        .map(value =>
          zio.aws.textract.model.primitives
            .HumanLoopActivationConditionsEvaluationResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.HumanLoopActivationOutput
  ): zio.aws.textract.model.HumanLoopActivationOutput.ReadOnly = new Wrapper(
    impl
  )
}
